/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetDoorAlarmStateTagged is the corresponding interface of BACnetDoorAlarmStateTagged
type BACnetDoorAlarmStateTagged interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// GetValue returns Value (property field)
	GetValue() BACnetDoorAlarmState
	// GetProprietaryValue returns ProprietaryValue (property field)
	GetProprietaryValue() uint32
	// GetIsProprietary returns IsProprietary (virtual field)
	GetIsProprietary() bool
	// IsBACnetDoorAlarmStateTagged is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetDoorAlarmStateTagged()
	// CreateBuilder creates a BACnetDoorAlarmStateTaggedBuilder
	CreateBACnetDoorAlarmStateTaggedBuilder() BACnetDoorAlarmStateTaggedBuilder
}

// _BACnetDoorAlarmStateTagged is the data-structure of this message
type _BACnetDoorAlarmStateTagged struct {
	Header           BACnetTagHeader
	Value            BACnetDoorAlarmState
	ProprietaryValue uint32

	// Arguments.
	TagNumber uint8
	TagClass  TagClass
}

var _ BACnetDoorAlarmStateTagged = (*_BACnetDoorAlarmStateTagged)(nil)

// NewBACnetDoorAlarmStateTagged factory function for _BACnetDoorAlarmStateTagged
func NewBACnetDoorAlarmStateTagged(header BACnetTagHeader, value BACnetDoorAlarmState, proprietaryValue uint32, tagNumber uint8, tagClass TagClass) *_BACnetDoorAlarmStateTagged {
	if header == nil {
		panic("header of type BACnetTagHeader for BACnetDoorAlarmStateTagged must not be nil")
	}
	return &_BACnetDoorAlarmStateTagged{Header: header, Value: value, ProprietaryValue: proprietaryValue, TagNumber: tagNumber, TagClass: tagClass}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetDoorAlarmStateTaggedBuilder is a builder for BACnetDoorAlarmStateTagged
type BACnetDoorAlarmStateTaggedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader, value BACnetDoorAlarmState, proprietaryValue uint32) BACnetDoorAlarmStateTaggedBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BACnetDoorAlarmStateTaggedBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetDoorAlarmStateTaggedBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetDoorAlarmState) BACnetDoorAlarmStateTaggedBuilder
	// WithProprietaryValue adds ProprietaryValue (property field)
	WithProprietaryValue(uint32) BACnetDoorAlarmStateTaggedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetDoorAlarmStateTaggedBuilder
	// WithArgTagClass sets a parser argument
	WithArgTagClass(TagClass) BACnetDoorAlarmStateTaggedBuilder
	// Build builds the BACnetDoorAlarmStateTagged or returns an error if something is wrong
	Build() (BACnetDoorAlarmStateTagged, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetDoorAlarmStateTagged
}

// NewBACnetDoorAlarmStateTaggedBuilder() creates a BACnetDoorAlarmStateTaggedBuilder
func NewBACnetDoorAlarmStateTaggedBuilder() BACnetDoorAlarmStateTaggedBuilder {
	return &_BACnetDoorAlarmStateTaggedBuilder{_BACnetDoorAlarmStateTagged: new(_BACnetDoorAlarmStateTagged)}
}

type _BACnetDoorAlarmStateTaggedBuilder struct {
	*_BACnetDoorAlarmStateTagged

	collectedErr []error
}

var _ (BACnetDoorAlarmStateTaggedBuilder) = (*_BACnetDoorAlarmStateTaggedBuilder)(nil)

func (b *_BACnetDoorAlarmStateTaggedBuilder) WithMandatoryFields(header BACnetTagHeader, value BACnetDoorAlarmState, proprietaryValue uint32) BACnetDoorAlarmStateTaggedBuilder {
	return b.WithHeader(header).WithValue(value).WithProprietaryValue(proprietaryValue)
}

func (b *_BACnetDoorAlarmStateTaggedBuilder) WithHeader(header BACnetTagHeader) BACnetDoorAlarmStateTaggedBuilder {
	b.Header = header
	return b
}

func (b *_BACnetDoorAlarmStateTaggedBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetDoorAlarmStateTaggedBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetDoorAlarmStateTaggedBuilder) WithValue(value BACnetDoorAlarmState) BACnetDoorAlarmStateTaggedBuilder {
	b.Value = value
	return b
}

func (b *_BACnetDoorAlarmStateTaggedBuilder) WithProprietaryValue(proprietaryValue uint32) BACnetDoorAlarmStateTaggedBuilder {
	b.ProprietaryValue = proprietaryValue
	return b
}

func (b *_BACnetDoorAlarmStateTaggedBuilder) WithArgTagNumber(tagNumber uint8) BACnetDoorAlarmStateTaggedBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetDoorAlarmStateTaggedBuilder) WithArgTagClass(tagClass TagClass) BACnetDoorAlarmStateTaggedBuilder {
	b.TagClass = tagClass
	return b
}

func (b *_BACnetDoorAlarmStateTaggedBuilder) Build() (BACnetDoorAlarmStateTagged, error) {
	if b.Header == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'header' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetDoorAlarmStateTagged.deepCopy(), nil
}

func (b *_BACnetDoorAlarmStateTaggedBuilder) MustBuild() BACnetDoorAlarmStateTagged {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetDoorAlarmStateTaggedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetDoorAlarmStateTaggedBuilder().(*_BACnetDoorAlarmStateTaggedBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetDoorAlarmStateTaggedBuilder creates a BACnetDoorAlarmStateTaggedBuilder
func (b *_BACnetDoorAlarmStateTagged) CreateBACnetDoorAlarmStateTaggedBuilder() BACnetDoorAlarmStateTaggedBuilder {
	if b == nil {
		return NewBACnetDoorAlarmStateTaggedBuilder()
	}
	return &_BACnetDoorAlarmStateTaggedBuilder{_BACnetDoorAlarmStateTagged: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetDoorAlarmStateTagged) GetHeader() BACnetTagHeader {
	return m.Header
}

func (m *_BACnetDoorAlarmStateTagged) GetValue() BACnetDoorAlarmState {
	return m.Value
}

func (m *_BACnetDoorAlarmStateTagged) GetProprietaryValue() uint32 {
	return m.ProprietaryValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetDoorAlarmStateTagged) GetIsProprietary() bool {
	ctx := context.Background()
	_ = ctx
	return bool(bool((m.GetValue()) == (BACnetDoorAlarmState_VENDOR_PROPRIETARY_VALUE)))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetDoorAlarmStateTagged(structType any) BACnetDoorAlarmStateTagged {
	if casted, ok := structType.(BACnetDoorAlarmStateTagged); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetDoorAlarmStateTagged); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetDoorAlarmStateTagged) GetTypeName() string {
	return "BACnetDoorAlarmStateTagged"
}

func (m *_BACnetDoorAlarmStateTagged) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	// Manual Field (value)
	lengthInBits += uint16(utils.InlineIf(m.GetIsProprietary(), func() any { return int32(int32(0)) }, func() any { return int32((int32(m.GetHeader().GetActualLength()) * int32(int32(8)))) }).(int32))

	// A virtual field doesn't have any in- or output.

	// Manual Field (proprietaryValue)
	lengthInBits += uint16(utils.InlineIf(m.GetIsProprietary(), func() any { return int32((int32(m.GetHeader().GetActualLength()) * int32(int32(8)))) }, func() any { return int32(int32(0)) }).(int32))

	return lengthInBits
}

func (m *_BACnetDoorAlarmStateTagged) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetDoorAlarmStateTaggedParse(ctx context.Context, theBytes []byte, tagNumber uint8, tagClass TagClass) (BACnetDoorAlarmStateTagged, error) {
	return BACnetDoorAlarmStateTaggedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, tagClass)
}

func BACnetDoorAlarmStateTaggedParseWithBufferProducer(tagNumber uint8, tagClass TagClass) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetDoorAlarmStateTagged, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetDoorAlarmStateTagged, error) {
		return BACnetDoorAlarmStateTaggedParseWithBuffer(ctx, readBuffer, tagNumber, tagClass)
	}
}

func BACnetDoorAlarmStateTaggedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (BACnetDoorAlarmStateTagged, error) {
	v, err := (&_BACnetDoorAlarmStateTagged{TagNumber: tagNumber, TagClass: tagClass}).parse(ctx, readBuffer, tagNumber, tagClass)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetDoorAlarmStateTagged) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (__bACnetDoorAlarmStateTagged BACnetDoorAlarmStateTagged, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetDoorAlarmStateTagged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetDoorAlarmStateTagged")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetTagClass()) == (tagClass))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "tag class doesn't match"})
	}

	// Validation
	if !(bool((bool((header.GetTagClass()) == (TagClass_APPLICATION_TAGS)))) || bool((bool((header.GetActualTagNumber()) == (tagNumber))))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	value, err := ReadManualField[BACnetDoorAlarmState](ctx, "value", readBuffer, EnsureType[BACnetDoorAlarmState](ReadEnumGeneric(ctx, readBuffer, header.GetActualLength(), BACnetDoorAlarmState_VENDOR_PROPRIETARY_VALUE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	isProprietary, err := ReadVirtualField[bool](ctx, "isProprietary", (*bool)(nil), bool((value) == (BACnetDoorAlarmState_VENDOR_PROPRIETARY_VALUE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'isProprietary' field"))
	}
	_ = isProprietary

	proprietaryValue, err := ReadManualField[uint32](ctx, "proprietaryValue", readBuffer, EnsureType[uint32](ReadProprietaryEnumGeneric(ctx, readBuffer, header.GetActualLength(), isProprietary)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'proprietaryValue' field"))
	}
	m.ProprietaryValue = proprietaryValue

	if closeErr := readBuffer.CloseContext("BACnetDoorAlarmStateTagged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetDoorAlarmStateTagged")
	}

	return m, nil
}

func (m *_BACnetDoorAlarmStateTagged) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetDoorAlarmStateTagged) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetDoorAlarmStateTagged"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetDoorAlarmStateTagged")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if err := WriteManualField[BACnetDoorAlarmState](ctx, "value", func(ctx context.Context) error { return WriteEnumGeneric(ctx, writeBuffer, m.GetValue()) }, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}
	// Virtual field
	isProprietary := m.GetIsProprietary()
	_ = isProprietary
	if _isProprietaryErr := writeBuffer.WriteVirtual(ctx, "isProprietary", m.GetIsProprietary()); _isProprietaryErr != nil {
		return errors.Wrap(_isProprietaryErr, "Error serializing 'isProprietary' field")
	}

	if err := WriteManualField[uint32](ctx, "proprietaryValue", func(ctx context.Context) error {
		return WriteProprietaryEnumGeneric(ctx, writeBuffer, m.GetProprietaryValue(), m.GetIsProprietary())
	}, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'proprietaryValue' field")
	}

	if popErr := writeBuffer.PopContext("BACnetDoorAlarmStateTagged"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetDoorAlarmStateTagged")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetDoorAlarmStateTagged) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetDoorAlarmStateTagged) GetTagClass() TagClass {
	return m.TagClass
}

//
////

func (m *_BACnetDoorAlarmStateTagged) IsBACnetDoorAlarmStateTagged() {}

func (m *_BACnetDoorAlarmStateTagged) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetDoorAlarmStateTagged) deepCopy() *_BACnetDoorAlarmStateTagged {
	if m == nil {
		return nil
	}
	_BACnetDoorAlarmStateTaggedCopy := &_BACnetDoorAlarmStateTagged{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		m.Value,
		m.ProprietaryValue,
		m.TagNumber,
		m.TagClass,
	}
	return _BACnetDoorAlarmStateTaggedCopy
}

func (m *_BACnetDoorAlarmStateTagged) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
