/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.select2;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.ResourceStreamResource;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.StringResourceStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.select2.AbstractSelect2Choice;
import org.wicketstuff.select2.ChoiceProvider;

public abstract class JsonResourceReference<T>
extends ResourceReference {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger(JsonResourceReference.class);

    public JsonResourceReference(String name) {
        super(JsonResourceReference.class, name);
    }

    public IResource getResource() {
        StringResourceStream resourceStream;
        ByteArrayOutputStream webResponse = new ByteArrayOutputStream();
        AbstractSelect2Choice.generateJSON(this.getChoiceProvider(), webResponse);
        try {
            resourceStream = new StringResourceStream((CharSequence)webResponse.toString("UTF-8"), "application/json");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("getResource", (Throwable)e);
            throw new WicketRuntimeException((Throwable)e);
        }
        return new ResourceStreamResource((IResourceStream)resourceStream);
    }

    protected abstract ChoiceProvider<T> getChoiceProvider();
}

