/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpc;

import com.hazelcast.config.Config;
import com.hazelcast.config.tpc.TpcSocketConfig;
import com.hazelcast.internal.tpcengine.TpcEngine;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.List;

public interface TpcServerBootstrap {
    public static final HazelcastProperty TPC_ENABLED = new HazelcastProperty("hazelcast.internal.tpc.enabled");
    public static final HazelcastProperty TPC_EVENTLOOP_COUNT = new HazelcastProperty("hazelcast.internal.tpc.eventloop.count");

    public static boolean loadTpcEnabled(Config config) {
        String s = System.getProperty(TPC_ENABLED.getName());
        if (s != null) {
            return Boolean.parseBoolean(s);
        }
        s = config.getProperties().getProperty(TPC_ENABLED.getName());
        if (s != null) {
            return Boolean.parseBoolean(s);
        }
        return config.getTpcConfig().isEnabled();
    }

    public void start();

    public void shutdown();

    public boolean isEnabled();

    public int eventloopCount();

    public List<Integer> getClientPorts();

    public TpcEngine getTpcEngine();

    public TpcSocketConfig getClientSocketConfig();
}

