/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl.operations;

import com.hazelcast.cluster.Address;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.cluster.impl.operations.AbstractClusterOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.NodeEngine;
import java.io.IOException;

public class MergeClustersOp
extends AbstractClusterOperation {
    private Address newTargetAddress;

    public MergeClustersOp() {
    }

    public MergeClustersOp(Address newTargetAddress) {
        this.newTargetAddress = newTargetAddress;
    }

    @Override
    public void run() {
        boolean local;
        Address caller = this.getCallerAddress();
        NodeEngine nodeEngine = this.getNodeEngine();
        Node node = nodeEngine.getNode();
        ClusterServiceImpl clusterService = node.getClusterService();
        Address masterAddress = clusterService.getMasterAddress();
        ILogger logger = node.loggingService.getLogger(this.getClass().getName());
        boolean bl = local = caller == null;
        if (!local && !caller.equals(masterAddress)) {
            logger.warning("Ignoring merge instruction sent from non-master endpoint: " + caller);
            return;
        }
        logger.warning(node.getThisAddress() + " is merging to " + this.newTargetAddress + ", because: instructed by master " + masterAddress);
        node.getNodeExtension().getAuditlogService().eventBuilder("HZ-0606").message("Merging this cluster into another one").addParameter("masterAddress", masterAddress).addParameter("targetAddress", this.newTargetAddress).log();
        nodeEngine.getExecutionService().execute("hz:cluster:splitbrain", () -> clusterService.merge(this.newTargetAddress));
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.newTargetAddress = (Address)in.readObject();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeObject(this.newTargetAddress);
    }

    @Override
    public int getClassId() {
        return 18;
    }
}

