/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.Cluster;
import com.hazelcast.cluster.Member;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.EventObject;
import java.util.Set;

@SuppressFBWarnings(value={"SE_BAD_FIELD"})
public class MembershipEvent
extends EventObject {
    public static final int MEMBER_ADDED = 1;
    public static final int MEMBER_REMOVED = 2;
    private static final long serialVersionUID = -2010865371829087371L;
    protected Member member;
    protected Set<Member> members;
    private final int eventType;

    public MembershipEvent(Cluster cluster, Member member, int eventType, Set<Member> members) {
        super(cluster);
        this.member = member;
        this.eventType = eventType;
        this.members = members;
    }

    public Set<Member> getMembers() {
        return this.members;
    }

    public Cluster getCluster() {
        return (Cluster)this.getSource();
    }

    public int getEventType() {
        return this.eventType;
    }

    public Member getMember() {
        return this.member;
    }

    @Override
    public String toString() {
        return String.format("MembershipEvent {member=%s, type=%s, members=%s}", this.member, switch (this.eventType) {
            case 1 -> "added";
            case 2 -> "removed";
            default -> throw new IllegalStateException();
        }, this.members);
    }
}

