/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.holder;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AnchorDataListHolder {
    private List<Integer> anchorPageList;
    private List<Map.Entry<Data, Data>> anchorDataList;

    public AnchorDataListHolder(List<Integer> anchorPageList, List<Map.Entry<Data, Data>> anchorDataList) {
        this.anchorPageList = anchorPageList;
        this.anchorDataList = anchorDataList;
    }

    public List<Integer> getAnchorPageList() {
        return this.anchorPageList;
    }

    public List<Map.Entry<Data, Data>> getAnchorDataList() {
        return this.anchorDataList;
    }

    public <K, V> List<Map.Entry<Integer, Map.Entry<K, V>>> asAnchorList(SerializationService serializationService) {
        ArrayList<Map.Entry<Integer, Map.Entry<K, V>>> anchorObjectList = new ArrayList<Map.Entry<Integer, Map.Entry<K, V>>>(this.anchorDataList.size());
        Iterator<Map.Entry<Data, Data>> dataEntryIterator = this.anchorDataList.iterator();
        for (Integer pageNumber : this.anchorPageList) {
            Map.Entry<Data, Data> dataEntry = dataEntryIterator.next();
            Object key = serializationService.toObject(dataEntry.getKey());
            Object value = serializationService.toObject(dataEntry.getValue());
            AbstractMap.SimpleImmutableEntry entry = new AbstractMap.SimpleImmutableEntry(key, value);
            anchorObjectList.add(new AbstractMap.SimpleImmutableEntry(pageNumber, entry));
        }
        return anchorObjectList;
    }

    public static AnchorDataListHolder of(List<Map.Entry<Integer, Map.Entry>> anchorList, SerializationService serializationService) {
        ArrayList<Map.Entry<Data, Data>> anchorDataList = new ArrayList<Map.Entry<Data, Data>>(anchorList.size());
        ArrayList<Integer> pageList = new ArrayList<Integer>(anchorList.size());
        anchorList.forEach(item -> {
            pageList.add((Integer)item.getKey());
            Map.Entry anchorEntry = (Map.Entry)item.getValue();
            anchorDataList.add(new AbstractMap.SimpleImmutableEntry(serializationService.toData(anchorEntry.getKey()), serializationService.toData(anchorEntry.getValue())));
        });
        return new AnchorDataListHolder(pageList, anchorDataList);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnchorDataListHolder that = (AnchorDataListHolder)o;
        return this.anchorPageList.equals(that.anchorPageList) && this.anchorDataList.equals(that.anchorDataList);
    }

    public int hashCode() {
        return Objects.hash(this.anchorPageList, this.anchorDataList);
    }
}

