/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.ByteArrayCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.ResourceDefinitionHolder;

public final class ResourceDefinitionCodec {
    private static final int RESOURCE_TYPE_FIELD_OFFSET = 0;
    private static final int INITIAL_FRAME_SIZE = 4;

    private ResourceDefinitionCodec() {
    }

    public static void encode(ClientMessage clientMessage, ResourceDefinitionHolder resourceDefinition) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[4]);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, resourceDefinition.getResourceType());
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, resourceDefinition.getId());
        CodecUtil.encodeNullable(clientMessage, resourceDefinition.getPayload(), ByteArrayCodec::encode);
        CodecUtil.encodeNullable(clientMessage, resourceDefinition.getResourceUrl(), StringCodec::encode);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static ResourceDefinitionHolder decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        int resourceType = FixedSizeTypesCodec.decodeInt(initialFrame.content, 0);
        String id = StringCodec.decode(iterator);
        byte[] payload = CodecUtil.decodeNullable(iterator, ByteArrayCodec::decode);
        String resourceUrl = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        CodecUtil.fastForwardToEndFrame(iterator);
        return new ResourceDefinitionHolder(id, resourceType, payload, resourceUrl);
    }
}

