/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.VectorPairCodec;
import com.hazelcast.client.impl.protocol.codec.custom.VectorSearchOptionsCodec;
import com.hazelcast.client.impl.protocol.codec.custom.VectorSearchResultCodec;
import com.hazelcast.client.impl.protocol.codec.holder.VectorPairHolder;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.vector.SearchOptions;
import com.hazelcast.vector.SearchResult;
import com.hazelcast.vector.VectorValues;
import com.hazelcast.vector.impl.DataSearchResult;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;

public final class VectorCollectionSearchNearVectorCodec {
    public static final int REQUEST_MESSAGE_TYPE = 2361344;
    public static final int RESPONSE_MESSAGE_TYPE = 2361345;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 16;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private VectorCollectionSearchNearVectorCodec() {
    }

    public static ClientMessage encodeRequest(String name, VectorValues vectors, SearchOptions options) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("VectorCollection.SearchNearVector");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 2361344);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        ListMultiFrameCodec.encode(clientMessage, vectors, VectorPairCodec::encode);
        VectorSearchOptionsCodec.encode(clientMessage, options);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        iterator.next();
        request.name = StringCodec.decode(iterator);
        request.vectors = ListMultiFrameCodec.decode(iterator, VectorPairCodec::decode);
        request.options = VectorSearchOptionsCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(Iterable<SearchResult<Data, Data>> result) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 2361345);
        clientMessage.add(initialFrame);
        ListMultiFrameCodec.encode(clientMessage, result, VectorSearchResultCodec::encode);
        return clientMessage;
    }

    public static List<DataSearchResult> decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        iterator.next();
        return ListMultiFrameCodec.decode(iterator, VectorSearchResultCodec::decode);
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public List<VectorPairHolder> vectors;
        public SearchOptions options;
    }
}

