/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.model.request;

import com.github.caldav4j.CalDAVConstants;
import com.github.caldav4j.exceptions.DOMValidationException;
import com.github.caldav4j.xml.OutputsDOM;
import com.github.caldav4j.xml.OutputsDOMBase;
import java.text.ParseException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import org.apache.jackrabbit.webdav.xml.Namespace;

public class TimeRange
extends OutputsDOMBase {
    public static final String ELEMENT_NAME = "time-range";
    public static final String ATTR_START = "start";
    public static final String ATTR_END = "end";
    private Date start = null;
    private Date end = null;

    public TimeRange(Date start, Date end) {
        this.start = start;
        this.end = end;
    }

    @Override
    protected String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    protected Namespace getNamespace() {
        return CalDAVConstants.NAMESPACE_CALDAV;
    }

    protected Collection<OutputsDOM> getChildren() {
        return null;
    }

    @Override
    protected String getTextContent() {
        return null;
    }

    @Override
    protected Map<String, String> getAttributes() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        if (this.start != null) {
            m.put(ATTR_START, this.start.toString());
        }
        if (this.end != null) {
            m.put(ATTR_END, this.end.toString());
        }
        return m;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public void setTimeRange(String start, String end) throws ParseException {
        this.start = new DateTime(start);
        this.end = new DateTime(end);
    }

    @Override
    public void validate() throws DOMValidationException {
        if (this.start == null && this.end == null) {
            this.throwValidationException("You must have a start or an end date");
        }
    }
}

