/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.util.UserDashboard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.dashboard.Dashboard;
import org.wicketstuff.dashboard.DashboardPersister;
import org.wicketstuff.dashboard.WidgetComparator;

public class UserDashboardPersister
implements DashboardPersister {
    private static final Logger log = LoggerFactory.getLogger(UserDashboardPersister.class);

    public Dashboard load() {
        return new XStreamDashboardPersister().load();
    }

    public void save(Dashboard dashboard) {
        new XStreamDashboardPersister().save(dashboard);
    }

    public static class XStreamDashboardPersister
    implements DashboardPersister {
        private File file = OmFileHelper.getUserDashboard((Long)WebSession.getUserId());
        private XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver(StandardCharsets.UTF_8.name()));

        public XStreamDashboardPersister() {
            this.xstream.setMode(1001);
            this.xstream.addPermission(NoTypePermission.NONE);
            this.xstream.addPermission(NullPermission.NULL);
            this.xstream.addPermission(PrimitiveTypePermission.PRIMITIVES);
            this.xstream.allowTypesByWildcard(new String[]{"org.apache.openmeetings.web.**"});
            this.xstream.allowTypeHierarchy(ArrayList.class);
            this.xstream.alias("dashboard", UserDashboard.class);
        }

        public Dashboard load() {
            Dashboard dashboard;
            if (!this.file.exists() || !this.file.isFile()) {
                return null;
            }
            FileInputStream is = new FileInputStream(this.file);
            try {
                dashboard = (Dashboard)this.xstream.fromXML((InputStream)is);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("Error while loading dashboard", (Throwable)e);
                    return null;
                }
            }
            ((InputStream)is).close();
            return dashboard;
        }

        public void save(Dashboard dashboard) {
            Collections.sort(dashboard.getWidgets(), new WidgetComparator());
            try (FileOutputStream os = new FileOutputStream(this.file);){
                this.xstream.toXML((Object)dashboard, (OutputStream)os);
            }
            catch (Exception e) {
                log.error("Error while saving dashboard", (Throwable)e);
            }
        }
    }
}

