/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.CsdlFunctionImport;

@JsonDeserialize(using=FunctionImportDeserializer.class)
class ClientCsdlFunctionImport
extends CsdlFunctionImport
implements Serializable {
    private static final long serialVersionUID = -1686801084142932402L;

    ClientCsdlFunctionImport() {
    }

    static class FunctionImportDeserializer
    extends AbstractClientCsdlEdmDeserializer<ClientCsdlFunctionImport> {
        FunctionImportDeserializer() {
        }

        @Override
        protected ClientCsdlFunctionImport doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlFunctionImport functImpImpl = new ClientCsdlFunctionImport();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Name".equals(jp.getCurrentName())) {
                        functImpImpl.setName(jp.nextTextValue());
                    } else if ("Function".equals(jp.getCurrentName())) {
                        functImpImpl.setFunction(jp.nextTextValue());
                    } else if ("EntitySet".equals(jp.getCurrentName())) {
                        functImpImpl.setEntitySet(jp.nextTextValue());
                    } else if ("IncludeInServiceDocument".equals(jp.getCurrentName())) {
                        functImpImpl.setIncludeInServiceDocument(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        functImpImpl.getAnnotations().add((CsdlAnnotation)jp.readValueAs(ClientCsdlAnnotation.class));
                    }
                }
                jp.nextToken();
            }
            return functImpImpl;
        }
    }
}

