/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.olingo.client.api.communication.request.ODataStreamer;
import org.apache.olingo.client.core.communication.util.PipedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractODataStreamer
implements ODataStreamer {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractODataStreamer.class);
    private static final byte[] CRLF = new byte[]{13, 10};
    private final PipedOutputStream bodyStreamWriter;

    public AbstractODataStreamer(PipedOutputStream bodyStreamWriter) {
        this.bodyStreamWriter = bodyStreamWriter;
    }

    protected void stream(byte[] src) {
        new Writer(src, this.bodyStreamWriter).run();
    }

    protected void newLine() {
        this.stream(CRLF);
    }

    @Override
    public PipedOutputStream getBodyStreamWriter() {
        return this.bodyStreamWriter;
    }

    private class Writer
    implements Runnable {
        final OutputStream os;
        final byte[] src;

        public Writer(byte[] src, OutputStream os) {
            this.os = os;
            this.src = Arrays.copyOf(src, src.length);
        }

        @Override
        public void run() {
            try {
                this.os.write(this.src);
            }
            catch (IOException e) {
                LOG.error("Error streaming object", e);
            }
        }
    }
}

