/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.client.core.edm.xml.ClientCsdlOnDelete;
import org.apache.olingo.client.core.edm.xml.ClientCsdlReferentialConstraint;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlOnDelete;

@JsonDeserialize(using=NavigationPropertyDeserializer.class)
class ClientCsdlNavigationProperty
extends CsdlNavigationProperty
implements Serializable {
    private static final long serialVersionUID = 6240231735592427582L;

    ClientCsdlNavigationProperty() {
    }

    static class NavigationPropertyDeserializer
    extends AbstractClientCsdlEdmDeserializer<CsdlNavigationProperty> {
        NavigationPropertyDeserializer() {
        }

        @Override
        protected CsdlNavigationProperty doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlNavigationProperty property = new ClientCsdlNavigationProperty();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Name".equals(jp.getCurrentName())) {
                        property.setName(jp.nextTextValue());
                    } else if ("Type".equals(jp.getCurrentName())) {
                        String metadataTypeName = jp.nextTextValue();
                        if (metadataTypeName.startsWith("Collection(")) {
                            property.setType(metadataTypeName.substring(metadataTypeName.indexOf("(") + 1, metadataTypeName.length() - 1));
                            property.setCollection(true);
                        } else {
                            property.setType(metadataTypeName);
                            property.setCollection(false);
                        }
                    } else if ("Nullable".equals(jp.getCurrentName())) {
                        property.setNullable(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                    } else if ("Partner".equals(jp.getCurrentName())) {
                        property.setPartner(jp.nextTextValue());
                    } else if ("ContainsTarget".equals(jp.getCurrentName())) {
                        property.setContainsTarget(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                    } else if ("ReferentialConstraint".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        property.getReferentialConstraints().add(jp.readValueAs(ClientCsdlReferentialConstraint.class));
                    } else if ("OnDelete".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        property.setOnDelete((CsdlOnDelete)jp.readValueAs(ClientCsdlOnDelete.class));
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        property.getAnnotations().add(jp.readValueAs(ClientCsdlAnnotation.class));
                    }
                }
                jp.nextToken();
            }
            return property;
        }
    }
}

