/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.annotation.processor.core.datasource;

import org.apache.olingo.odata2.annotation.processor.core.datasource.ValueAccess;
import org.apache.olingo.odata2.annotation.processor.core.util.AnnotationHelper;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.exception.ODataNotImplementedException;

public class AnnotationValueAccess
implements ValueAccess {
    private final AnnotationHelper annotationHelper = new AnnotationHelper();

    @Override
    public <T> Object getPropertyValue(T data, EdmProperty property) throws ODataException {
        if (data == null) {
            return null;
        }
        if (this.annotationHelper.isEdmAnnotated(data)) {
            return this.annotationHelper.getValueForProperty(data, property.getName());
        }
        throw new ODataNotImplementedException(ODataNotImplementedException.COMMON);
    }

    @Override
    public <T, V> void setPropertyValue(T data, EdmProperty property, V value) throws ODataException {
        if (data != null) {
            if (this.annotationHelper.isEdmAnnotated(data)) {
                this.annotationHelper.setValueForProperty(data, property.getName(), value);
            } else {
                throw new ODataNotImplementedException(ODataNotImplementedException.COMMON);
            }
        }
    }

    @Override
    public <T> Class<?> getPropertyType(T data, EdmProperty property) throws ODataException {
        if (data == null) {
            return null;
        }
        if (this.annotationHelper.isEdmAnnotated(data)) {
            Class<?> fieldType = this.annotationHelper.getFieldTypeForProperty(data, property.getName());
            if (fieldType == null) {
                throw new ODataException("No field type found for property " + property);
            }
            return fieldType;
        }
        throw new ODataNotImplementedException(ODataNotImplementedException.COMMON);
    }

    @Override
    public <T> Object getMappingValue(T data, EdmMapping mapping) throws ODataException {
        if (mapping != null && mapping.getMediaResourceMimeTypeKey() != null) {
            return this.annotationHelper.getValueForProperty(data, mapping.getMediaResourceMimeTypeKey());
        }
        return null;
    }

    @Override
    public <T, V> void setMappingValue(T data, EdmMapping mapping, V value) throws ODataException {
        if (mapping != null && mapping.getMediaResourceMimeTypeKey() != null) {
            this.annotationHelper.setValueForProperty(data, mapping.getMediaResourceMimeTypeKey(), value);
        }
    }
}

