/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Set;
import org.apache.nifi.web.api.dto.PortDTO;

@XmlType(name="controller")
public class ControllerDTO {
    private String id;
    private String name;
    private String comments;
    private Integer runningCount;
    private Integer stoppedCount;
    private Integer invalidCount;
    private Integer disabledCount;
    private Integer activeRemotePortCount;
    private Integer inactiveRemotePortCount;
    private Integer inputPortCount;
    private Integer outputPortCount;
    private Integer remoteSiteListeningPort;
    private Integer remoteSiteHttpListeningPort;
    private Boolean siteToSiteSecure;
    private String instanceId;
    private Set<PortDTO> inputPorts;
    private Set<PortDTO> outputPorts;

    @Schema(description="The id of the NiFi.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Schema(description="The name of the NiFi.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Schema(description="The comments for the NiFi.")
    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @Schema(description="The input ports available to send data to for the NiFi.")
    public Set<PortDTO> getInputPorts() {
        return this.inputPorts;
    }

    public void setInputPorts(Set<PortDTO> inputPorts) {
        this.inputPorts = inputPorts;
    }

    @Schema(description="The output ports available to received data from the NiFi.")
    public Set<PortDTO> getOutputPorts() {
        return this.outputPorts;
    }

    public void setOutputPorts(Set<PortDTO> outputPorts) {
        this.outputPorts = outputPorts;
    }

    @Schema(description="If clustered, the id of the Cluster Manager, otherwise the id of the NiFi.")
    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    @Schema(description="The Socket Port on which this instance is listening for Remote Transfers of FlowFiles. If this instance is not configured to receive FlowFiles from remote instances, this will be null.")
    public Integer getRemoteSiteListeningPort() {
        return this.remoteSiteListeningPort;
    }

    public void setRemoteSiteListeningPort(Integer port) {
        this.remoteSiteListeningPort = port;
    }

    @Schema(description="The HTTP(S) Port on which this instance is listening for Remote Transfers of FlowFiles. If this instance is not configured to receive FlowFiles from remote instances, this will be null.")
    public Integer getRemoteSiteHttpListeningPort() {
        return this.remoteSiteHttpListeningPort;
    }

    public void setRemoteSiteHttpListeningPort(Integer remoteSiteHttpListeningPort) {
        this.remoteSiteHttpListeningPort = remoteSiteHttpListeningPort;
    }

    @Schema(description="Indicates whether or not Site-to-Site communications with this instance is secure (2-way authentication).")
    public Boolean isSiteToSiteSecure() {
        return this.siteToSiteSecure;
    }

    public void setSiteToSiteSecure(Boolean siteToSiteSecure) {
        this.siteToSiteSecure = siteToSiteSecure;
    }

    @Schema(description="The number of running components in the NiFi.")
    public Integer getRunningCount() {
        return this.runningCount;
    }

    public void setRunningCount(Integer runningCount) {
        this.runningCount = runningCount;
    }

    @Schema(description="The number of stopped components in the NiFi.")
    public Integer getStoppedCount() {
        return this.stoppedCount;
    }

    public void setStoppedCount(Integer stoppedCount) {
        this.stoppedCount = stoppedCount;
    }

    @Schema(description="The number of active remote ports contained in the NiFi.")
    public Integer getActiveRemotePortCount() {
        return this.activeRemotePortCount;
    }

    public void setActiveRemotePortCount(Integer activeRemotePortCount) {
        this.activeRemotePortCount = activeRemotePortCount;
    }

    @Schema(description="The number of inactive remote ports contained in the NiFi.")
    public Integer getInactiveRemotePortCount() {
        return this.inactiveRemotePortCount;
    }

    public void setInactiveRemotePortCount(Integer inactiveRemotePortCount) {
        this.inactiveRemotePortCount = inactiveRemotePortCount;
    }

    @Schema(description="The number of input ports contained in the NiFi.")
    public Integer getInputPortCount() {
        return this.inputPortCount;
    }

    public void setInputPortCount(Integer inputPortCount) {
        this.inputPortCount = inputPortCount;
    }

    @Schema(description="The number of invalid components in the NiFi.")
    public Integer getInvalidCount() {
        return this.invalidCount;
    }

    public void setInvalidCount(Integer invalidCount) {
        this.invalidCount = invalidCount;
    }

    @Schema(description="The number of disabled components in the NiFi.")
    public Integer getDisabledCount() {
        return this.disabledCount;
    }

    public void setDisabledCount(Integer disabledCount) {
        this.disabledCount = disabledCount;
    }

    @Schema(description="The number of output ports in the NiFi.")
    public Integer getOutputPortCount() {
        return this.outputPortCount;
    }

    public void setOutputPortCount(Integer outputPortCount) {
        this.outputPortCount = outputPortCount;
    }
}

