/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parameter;

import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.nifi.asset.Asset;
import org.apache.nifi.parameter.ParameterDescriptor;
import org.apache.nifi.parameter.ParameterTag;

public class Parameter {
    private final ParameterDescriptor descriptor;
    private final String value;
    private final String parameterContextId;
    private final boolean provided;
    private final List<Asset> referencedAssets;
    private final List<ParameterTag> tags;

    private Parameter(Builder builder) {
        this.descriptor = new ParameterDescriptor.Builder().name(builder.name).description(builder.description).sensitive(builder.sensitive).build();
        this.parameterContextId = builder.parameterContextId;
        this.provided = builder.provided;
        this.tags = builder.tags;
        this.referencedAssets = builder.referencedAssets;
        this.value = this.referencedAssets == null || this.referencedAssets.isEmpty() ? builder.value : this.referencedAssets.stream().map(Asset::getFile).map(File::getAbsolutePath).collect(Collectors.joining(","));
    }

    public ParameterDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getValue() {
        return this.value;
    }

    public List<Asset> getReferencedAssets() {
        return this.referencedAssets;
    }

    public String getParameterContextId() {
        return this.parameterContextId;
    }

    public List<ParameterTag> getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter parameter = (Parameter)o;
        return Objects.equals(this.descriptor, parameter.descriptor) && Objects.equals(this.value, parameter.value) && Objects.equals(this.parameterContextId, parameter.parameterContextId) && Objects.equals(this.referencedAssets, parameter.referencedAssets) && Objects.equals(this.tags, parameter.tags);
    }

    public int hashCode() {
        return Objects.hash(this.descriptor, this.value, this.tags);
    }

    public boolean isProvided() {
        return this.provided;
    }

    public static class Builder {
        private String name;
        private String description;
        private boolean sensitive;
        private String value;
        private String parameterContextId;
        private boolean provided;
        private List<Asset> referencedAssets = List.of();
        private List<ParameterTag> tags = List.of();

        public Builder fromParameter(Parameter parameter) {
            this.descriptor(parameter.getDescriptor());
            this.parameterContextId = parameter.getParameterContextId();
            this.provided = parameter.isProvided();
            this.referencedAssets = parameter.getReferencedAssets() == null ? List.of() : parameter.getReferencedAssets();
            List<Object> list = this.tags = parameter.getTags() == null ? List.of() : parameter.getTags();
            if (this.referencedAssets.isEmpty()) {
                this.value = parameter.getValue();
            }
            return this;
        }

        public Builder descriptor(ParameterDescriptor descriptor) {
            this.name = descriptor.getName();
            this.description = descriptor.getDescription();
            this.sensitive = descriptor.isSensitive();
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder sensitive(boolean sensitive) {
            this.sensitive = sensitive;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.referencedAssets = List.of();
            return this;
        }

        public Builder parameterContextId(String parameterContextId) {
            this.parameterContextId = parameterContextId;
            return this;
        }

        public Builder provided(Boolean provided) {
            this.provided = provided != null && provided != false;
            return this;
        }

        public Builder referencedAssets(List<Asset> referencedAssets) {
            List<Object> list = this.referencedAssets = referencedAssets == null ? List.of() : referencedAssets;
            if (!this.referencedAssets.isEmpty()) {
                this.value = null;
            }
            return this;
        }

        public Builder tags(List<ParameterTag> tags) {
            this.tags = tags == null ? List.of() : tags;
            return this;
        }

        public Parameter build() {
            if (this.name == null) {
                throw new IllegalStateException("Name or Descriptor is required");
            }
            if (this.value != null && this.referencedAssets != null && !this.referencedAssets.isEmpty()) {
                throw new IllegalStateException("A Parameter's value or referenced assets may be set but not both");
            }
            return new Parameter(this);
        }
    }
}

