/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.util.StringUtil;

public interface HttpCookieStore {
    public boolean add(URI var1, HttpCookie var2);

    public List<HttpCookie> all();

    public List<HttpCookie> match(URI var1);

    public boolean remove(URI var1, HttpCookie var2);

    public boolean clear();

    public static class Default
    implements HttpCookieStore {
        private final ReadWriteLock lock = new ReentrantReadWriteLock();
        private final Map<String, List<StoredHttpCookie>> cookies = new HashMap<String, List<StoredHttpCookie>>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(URI uri, HttpCookie cookie) {
            if (!this.validateCookiePrefix(uri, cookie)) {
                return false;
            }
            String resolvedDomain = this.resolveDomain(uri, cookie);
            if (resolvedDomain == null) {
                return false;
            }
            String resolvedPath = this.resolvePath(uri, cookie);
            boolean[] added = new boolean[1];
            StoredHttpCookie storedCookie = new StoredHttpCookie(cookie, uri, resolvedDomain, resolvedPath);
            this.lock.writeLock().lock();
            try {
                String key = resolvedDomain.toLowerCase(Locale.ENGLISH);
                this.cookies.compute(key, (k, v) -> {
                    if (v != null) {
                        v.remove(storedCookie);
                    }
                    if (cookie.isExpired()) {
                        return v == null || v.isEmpty() ? null : v;
                    }
                    added[0] = true;
                    if (v == null) {
                        v = new ArrayList<StoredHttpCookie>();
                    }
                    v.add(storedCookie);
                    return v;
                });
                boolean bl = added[0];
                return bl;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        private String resolveDomain(URI uri, HttpCookie cookie) {
            String uriDomain = uri.getHost();
            if (uriDomain == null) {
                return null;
            }
            String cookieDomain = cookie.getDomain();
            if (cookieDomain == null) {
                return uriDomain;
            }
            String resolvedDomain = cookieDomain;
            if (resolvedDomain.startsWith(".")) {
                resolvedDomain = cookieDomain.substring(1);
            }
            if (resolvedDomain.endsWith(".")) {
                resolvedDomain = uriDomain;
            }
            if (!this.allowDomain(resolvedDomain)) {
                return null;
            }
            if (!Default.isSameOrSubDomain(uriDomain, resolvedDomain)) {
                return null;
            }
            return resolvedDomain;
        }

        private String resolvePath(URI uri, HttpCookie cookie) {
            String resolvedPath = cookie.getPath();
            if (resolvedPath == null || !resolvedPath.startsWith("/")) {
                String uriPath = uri.getRawPath();
                if (StringUtil.isBlank((String)uriPath) || !uriPath.startsWith("/")) {
                    resolvedPath = "/";
                } else {
                    int lastSlash = uriPath.lastIndexOf(47);
                    resolvedPath = uriPath.substring(0, lastSlash);
                    if (resolvedPath.isEmpty()) {
                        resolvedPath = "/";
                    }
                }
            }
            return resolvedPath;
        }

        private boolean validateCookiePrefix(URI uri, HttpCookie cookie) {
            String name = cookie.getName();
            if (name == null) {
                return true;
            }
            boolean secure = HttpScheme.isSecure(uri.getScheme());
            if (name.startsWith("__Host-")) {
                if (!secure) {
                    return false;
                }
                if (!cookie.isSecure()) {
                    return false;
                }
                if (cookie.getDomain() != null) {
                    return false;
                }
                if (!"/".equals(cookie.getPath())) {
                    return false;
                }
            } else if (name.startsWith("__Secure-")) {
                if (!secure) {
                    return false;
                }
                if (!cookie.isSecure()) {
                    return false;
                }
            }
            return true;
        }

        protected boolean allowDomain(String domain) {
            if (domain.endsWith(".")) {
                domain = domain.substring(0, domain.length() - 1);
            }
            if (domain.contains(".")) {
                return true;
            }
            if (domain.equals("localhost")) {
                return true;
            }
            return domain.startsWith("[") && domain.endsWith("]");
        }

        @Override
        public List<HttpCookie> all() {
            this.lock.readLock().lock();
            try {
                List<HttpCookie> list = this.cookies.values().stream().flatMap(Collection::stream).filter(Predicate.not(StoredHttpCookie::isExpired)).map(HttpCookie.class::cast).toList();
                return list;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<HttpCookie> match(URI uri) {
            String uriDomain = uri.getHost();
            if (uriDomain == null) {
                return List.of();
            }
            String path = uri.getRawPath();
            if (path == null || path.isBlank()) {
                path = "/";
            }
            boolean secure = HttpScheme.isSecure(uri.getScheme());
            ArrayList<StoredHttpCookie> result = null;
            HashMap<String, List> expired = null;
            this.lock.readLock().lock();
            try {
                String domain = uriDomain.toLowerCase(Locale.ENGLISH);
                while (domain != null) {
                    List<StoredHttpCookie> stored = this.cookies.get(domain);
                    if (stored != null) {
                        for (StoredHttpCookie cookie : stored) {
                            if (cookie.isExpired()) {
                                if (expired == null) {
                                    expired = new HashMap<String, List>();
                                }
                                expired.computeIfAbsent(domain, k -> new ArrayList()).add(cookie);
                                continue;
                            }
                            if (cookie.isSecure() && !secure || !Default.domainMatches(uriDomain, cookie.domain, cookie.getWrapped().getDomain()) || !Default.pathMatches(path, cookie.path)) continue;
                            if (result == null) {
                                result = new ArrayList<StoredHttpCookie>();
                            }
                            result.add(cookie);
                        }
                    }
                    domain = this.parentDomain(domain);
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            if (expired != null) {
                this.lock.writeLock().lock();
                try {
                    for (Map.Entry entry : expired.entrySet()) {
                        String domain = (String)entry.getKey();
                        List<StoredHttpCookie> stored = this.cookies.get(domain);
                        if (stored == null) continue;
                        stored.removeAll((Collection)entry.getValue());
                        if (!stored.isEmpty()) continue;
                        this.cookies.remove(domain);
                    }
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
            return result == null ? List.of() : result;
        }

        private static boolean domainMatches(String uriDomain, String domain, String cookieDomain) {
            if (cookieDomain == null || cookieDomain.endsWith(".")) {
                return uriDomain.equalsIgnoreCase(domain);
            }
            return Default.isSameOrSubDomain(uriDomain, cookieDomain);
        }

        private static boolean isSameOrSubDomain(String subDomain, String domain) {
            int domainLength;
            int subDomainLength = subDomain.length();
            if (!subDomain.regionMatches(true, subDomainLength - (domainLength = domain.length()), domain, 0, domainLength)) {
                return false;
            }
            int beforeMatch = subDomainLength - domainLength - 1;
            if (beforeMatch < 0) {
                return true;
            }
            return subDomain.charAt(beforeMatch) == '.';
        }

        private static boolean pathMatches(String uriPath, String cookiePath) {
            if (cookiePath == null) {
                return true;
            }
            if (uriPath.equals(cookiePath)) {
                return true;
            }
            if (uriPath.startsWith(cookiePath)) {
                return cookiePath.endsWith("/") || uriPath.charAt(cookiePath.length()) == '/';
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(URI uri, HttpCookie cookie) {
            String uriDomain = uri.getHost();
            if (uriDomain == null) {
                return false;
            }
            String resolvedPath = this.resolvePath(uri, cookie);
            boolean[] removed = new boolean[1];
            this.lock.writeLock().lock();
            try {
                String domain = uriDomain.toLowerCase(Locale.ENGLISH);
                while (domain != null) {
                    this.cookies.compute(domain, (k, v) -> {
                        if (v == null) {
                            return null;
                        }
                        Iterator iterator = v.iterator();
                        while (iterator.hasNext()) {
                            StoredHttpCookie storedCookie = (StoredHttpCookie)iterator.next();
                            if (!uriDomain.equalsIgnoreCase(storedCookie.uri.getHost()) || !storedCookie.path.equals(resolvedPath) || !storedCookie.getWrapped().getName().equals(cookie.getName())) continue;
                            iterator.remove();
                            removed[0] = true;
                        }
                        return v.isEmpty() ? null : v;
                    });
                    domain = this.parentDomain(domain);
                }
                boolean bl = removed[0];
                return bl;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        private String parentDomain(String domain) {
            int dot = domain.indexOf(46);
            if (dot < 0) {
                return null;
            }
            if ((domain = domain.substring(dot + 1)).indexOf(46) < 0) {
                return null;
            }
            return domain;
        }

        @Override
        public boolean clear() {
            this.lock.writeLock().lock();
            try {
                if (this.cookies.isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                this.cookies.clear();
                boolean bl = true;
                return bl;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        private static class StoredHttpCookie
        extends HttpCookie.Wrapper {
            private final long creationNanoTime = NanoTime.now();
            private final URI uri;
            private final String domain;
            private final String path;

            private StoredHttpCookie(HttpCookie wrapped, URI uri, String domain, String path) {
                super(wrapped);
                this.uri = Objects.requireNonNull(uri);
                this.domain = Objects.requireNonNull(domain);
                this.path = Objects.requireNonNull(path);
            }

            @Override
            public boolean isExpired() {
                long maxAge = this.getMaxAge();
                if (maxAge >= 0L && NanoTime.secondsSince((long)this.creationNanoTime) > maxAge) {
                    return true;
                }
                Instant expires = this.getExpires();
                return expires != null && Instant.now().isAfter(expires);
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.getWrapped().getName(), this.domain.toLowerCase(Locale.ENGLISH), this.path);
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof StoredHttpCookie)) {
                    return false;
                }
                StoredHttpCookie that = (StoredHttpCookie)obj;
                return this.getName().equals(that.getName()) && this.domain.equalsIgnoreCase(that.domain) && this.path.equals(that.path);
            }
        }
    }

    public static class Empty
    implements HttpCookieStore {
        @Override
        public boolean add(URI uri, HttpCookie cookie) {
            return false;
        }

        @Override
        public List<HttpCookie> all() {
            return List.of();
        }

        @Override
        public List<HttpCookie> match(URI uri) {
            return List.of();
        }

        @Override
        public boolean remove(URI uri, HttpCookie cookie) {
            return false;
        }

        @Override
        public boolean clear() {
            return false;
        }
    }
}

