/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.jackson;

import java.time.Duration;
import java.time.Instant;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.RememberMeAuthenticationToken;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.authority.FactorGrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.jackson.AnonymousAuthenticationTokenMixin;
import org.springframework.security.jackson.BadCredentialsExceptionMixin;
import org.springframework.security.jackson.FactorGrantedAuthorityMixin;
import org.springframework.security.jackson.RememberMeAuthenticationTokenMixin;
import org.springframework.security.jackson.SecurityJacksonModule;
import org.springframework.security.jackson.SimpleGrantedAuthorityMixin;
import org.springframework.security.jackson.TestingAuthenticationTokenMixin;
import org.springframework.security.jackson.UserMixin;
import org.springframework.security.jackson.UsernamePasswordAuthenticationTokenMixin;
import tools.jackson.core.Version;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.cfg.DatatypeFeature;
import tools.jackson.databind.cfg.DateTimeFeature;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.jsontype.BasicPolymorphicTypeValidator;

public class CoreJacksonModule
extends SecurityJacksonModule {
    public CoreJacksonModule() {
        super(CoreJacksonModule.class.getName(), new Version(1, 0, 0, null, null, null));
    }

    protected CoreJacksonModule(String name, Version version) {
        super(name, version);
    }

    @Override
    public void configurePolymorphicTypeValidator(BasicPolymorphicTypeValidator.Builder builder) {
        builder.allowIfSubType(Instant.class).allowIfSubType(Duration.class).allowIfSubType(SimpleGrantedAuthority.class).allowIfSubType(FactorGrantedAuthority.class).allowIfSubType(UsernamePasswordAuthenticationToken.class).allowIfSubType(RememberMeAuthenticationToken.class).allowIfSubType(AnonymousAuthenticationToken.class).allowIfSubType(User.class).allowIfSubType(BadCredentialsException.class).allowIfSubType(SecurityContextImpl.class).allowIfSubType(TestingAuthenticationToken.class).allowIfSubType("java.util.Collections$UnmodifiableSet").allowIfSubType("java.util.Collections$UnmodifiableRandomAccessList").allowIfSubType("java.util.Collections$EmptyList").allowIfSubType("java.util.ArrayList").allowIfSubType("java.util.HashMap").allowIfSubType("java.util.Collections$EmptyMap").allowIfSubType("java.util.Date").allowIfSubType("java.util.Arrays$ArrayList").allowIfSubType("java.util.Collections$UnmodifiableMap").allowIfSubType("java.util.LinkedHashMap").allowIfSubType("java.util.Collections$SingletonList").allowIfSubType("java.util.TreeMap").allowIfSubType("java.util.HashSet").allowIfSubType("java.util.LinkedHashSet");
    }

    public void setupModule(JacksonModule.SetupContext context) {
        ((MapperBuilder)context.getOwner()).enable(new DatatypeFeature[]{DateTimeFeature.WRITE_DATES_AS_TIMESTAMPS});
        context.setMixIn(AnonymousAuthenticationToken.class, AnonymousAuthenticationTokenMixin.class);
        context.setMixIn(RememberMeAuthenticationToken.class, RememberMeAuthenticationTokenMixin.class);
        context.setMixIn(SimpleGrantedAuthority.class, SimpleGrantedAuthorityMixin.class);
        context.setMixIn(FactorGrantedAuthority.class, FactorGrantedAuthorityMixin.class);
        context.setMixIn(User.class, UserMixin.class);
        context.setMixIn(UsernamePasswordAuthenticationToken.class, UsernamePasswordAuthenticationTokenMixin.class);
        context.setMixIn(TestingAuthenticationToken.class, TestingAuthenticationTokenMixin.class);
        context.setMixIn(BadCredentialsException.class, BadCredentialsExceptionMixin.class);
    }
}

