/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization;

import java.util.Collections;
import java.util.List;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.authorization.RequiredFactorError;
import org.springframework.util.Assert;

public class FactorAuthorizationDecision
implements AuthorizationResult {
    private final List<RequiredFactorError> factorErrors;

    public FactorAuthorizationDecision(List<RequiredFactorError> factorErrors) {
        Assert.notNull(factorErrors, (String)"factorErrors cannot be null");
        Assert.noNullElements(factorErrors, (String)"factorErrors must not contain null elements");
        this.factorErrors = Collections.unmodifiableList(factorErrors);
    }

    public List<RequiredFactorError> getFactorErrors() {
        return this.factorErrors;
    }

    @Override
    public boolean isGranted() {
        return this.factorErrors.isEmpty();
    }
}

