/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.security;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class MessageDigestUtils {
    private static final String DIGEST_ALGORITHM = "SHA-256";
    private static final int BUFFER_LENGTH = 1024;
    private static final int START_READ_INDEX = 0;
    private static final int STREAM_END_INDEX = -1;

    private MessageDigestUtils() {
    }

    public static byte[] getDigest(byte[] bytes) {
        MessageDigest messageDigest = MessageDigestUtils.getMessageDigest();
        messageDigest.update(bytes);
        return messageDigest.digest();
    }

    public static byte[] getDigest(InputStream inputStream) throws IOException {
        MessageDigest messageDigest = MessageDigestUtils.getMessageDigest();
        byte[] buffer = new byte[1024];
        int bytesRead = inputStream.read(buffer, 0, 1024);
        while (bytesRead > -1) {
            messageDigest.update(buffer, 0, bytesRead);
            bytesRead = inputStream.read(buffer, 0, 1024);
        }
        return messageDigest.digest();
    }

    private static MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance(DIGEST_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(DIGEST_ALGORITHM, e);
        }
    }
}

