/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.nar.NarUnpackMode;
import org.apache.nifi.nar.NarUnpacker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatelessNiFi {
    private static final Logger logger = LoggerFactory.getLogger(StatelessNiFi.class);
    public static final String PROGRAM_CLASS_NAME = "org.apache.nifi.stateless.runtimes.Program";
    public static final String EXTRACT_NARS = "ExtractNars";

    public static void main(String[] args) throws IOException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        File frameworkWorkingDirectory;
        String nifi_home = System.getenv("NIFI_HOME");
        if (nifi_home == null || nifi_home.equals("")) {
            nifi_home = ".";
        }
        File libDir = new File(nifi_home + "/lib");
        File narWorkingDirectory = new File(nifi_home + "/work/stateless-nars");
        if (args.length >= 1 && args[0].equals(EXTRACT_NARS)) {
            if (!libDir.exists()) {
                System.out.println("Specified lib directory <" + libDir + "> does not exist");
                return;
            }
            File[] narFiles = libDir.listFiles(file -> file.getName().endsWith(".nar"));
            if (narFiles == null) {
                System.out.println("Could not obtain listing of lib directory <" + libDir + ">");
                return;
            }
            if (!narWorkingDirectory.exists() && !narWorkingDirectory.mkdirs()) {
                throw new IOException("Could not create NAR working directory <" + narWorkingDirectory + ">");
            }
            logger.info("Unpacking {} NARs", (Object)narFiles.length);
            long startUnpack = System.nanoTime();
            for (File narFile : narFiles) {
                NarUnpacker.unpackNar((File)narFile, (File)narWorkingDirectory, (boolean)false, (NarUnpackMode)NarUnpackMode.UNPACK_TO_UBER_JAR);
            }
            long millis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startUnpack);
            logger.info("Finished unpacking {} NARs in {} millis", (Object)narFiles.length, (Object)millis);
            System.exit(0);
        }
        try {
            frameworkWorkingDirectory = Objects.requireNonNull(narWorkingDirectory.listFiles(file -> file.getName().startsWith("nifi-framework")))[0];
        }
        catch (Exception ex) {
            throw new FileNotFoundException("Could not find core stateless dependencies in the working directory <" + narWorkingDirectory + ">");
        }
        File bundledDependenciesDir = new File(frameworkWorkingDirectory, "NAR-INF/bundled-dependencies");
        File[] jarFiles = bundledDependenciesDir.listFiles();
        if (jarFiles == null) {
            throw new IOException("Could not obtain listing of NiFi-Framework NAR's bundled dependencies in working directory <" + bundledDependenciesDir + ">");
        }
        URL[] jarUrls = StatelessNiFi.toURLs(jarFiles);
        ClassLoader rootClassLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader frameworkClassLoader = new URLClassLoader(jarUrls, rootClassLoader);
        Thread.currentThread().setContextClassLoader(frameworkClassLoader);
        Class<?> programClass = Class.forName(PROGRAM_CLASS_NAME, true, frameworkClassLoader);
        Method launchMethod = programClass.getMethod("launch", String[].class, ClassLoader.class, File.class);
        launchMethod.setAccessible(true);
        launchMethod.invoke(null, args, rootClassLoader, narWorkingDirectory);
    }

    private static URL[] toURLs(File[] files) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : files) {
            urls.add(file.toURI().toURL());
        }
        return urls.toArray(new URL[0]);
    }
}

