/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures;

import java.util.Arrays;

public class IntArrayList {
    private int[] data;
    private int size;

    public IntArrayList(int initialCapacity) {
        this.data = new int[initialCapacity];
    }

    public IntArrayList() {
        this(4);
    }

    public void trimToSize() {
        int oldCapacity = this.data.length;
        if (this.size < oldCapacity) {
            this.data = Arrays.copyOf(this.data, this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.data.length;
        if (minCapacity > oldCapacity) {
            int newCapacity;
            if (oldCapacity == 0) {
                oldCapacity = 1;
            }
            if ((newCapacity = (oldCapacity << 3) / 5 + 1) < minCapacity) {
                newCapacity = minCapacity;
            }
            this.data = Arrays.copyOf(this.data, newCapacity);
        }
    }

    public int getCapacity() {
        return this.data.length;
    }

    public void setCapacity(int capacity) {
        this.data = new int[capacity];
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(int element) {
        return this.indexOf(element) >= 0;
    }

    public int indexOf(int element) {
        return IntArrayList.indexOf(this.data, this.size, element);
    }

    public static int indexOf(int[] array, int element) {
        return IntArrayList.indexOf(array, array.length, element);
    }

    public static int indexOf(int[] array, int size, int element) {
        for (int i = 0; i < size; ++i) {
            if (element != array[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int element) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (element != this.data[i]) continue;
            return i;
        }
        return -1;
    }

    public final Object clone() throws CloneNotSupportedException {
        IntArrayList v = (IntArrayList)super.clone();
        v.data = new int[this.size];
        System.arraycopy(this.data, 0, v.data, 0, this.size);
        return v;
    }

    public int[] toArray() {
        int[] result = new int[this.size];
        System.arraycopy(this.data, 0, result, 0, this.size);
        return result;
    }

    public int[] toArray(int[] a) {
        if (a.length < this.size) {
            a = new int[this.size];
        }
        System.arraycopy(this.data, 0, a, 0, this.size);
        return a;
    }

    public int get(int index) {
        this.checkRange(index);
        return this.data[index];
    }

    public int set(int index, int element) {
        this.checkRange(index);
        int oldValue = this.data[index];
        this.data[index] = element;
        return oldValue;
    }

    public void add(int element) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size++] = element;
    }

    public void add(int index, int element) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        this.data[index] = element;
        ++this.size;
    }

    public int remove(int index) {
        this.checkRange(index);
        int oldValue = this.data[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.data, index + 1, this.data, index, numMoved);
        }
        --this.size;
        return oldValue;
    }

    public void clear() {
        this.size = 0;
    }

    protected void removeRange(int fromIndex, int toIndex) {
        int numMoved = this.size - toIndex;
        System.arraycopy(this.data, toIndex, this.data, fromIndex, numMoved);
        this.size -= toIndex - fromIndex;
    }

    private void checkRange(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }
}

