/*
 * Decompiled with CFR 0.152.
 */
package v14.h2.value;

import java.util.Arrays;
import java.util.Locale;
import v14.h2.message.DbException;
import v14.h2.value.ExtTypeInfo;
import v14.h2.value.TypeInfo;
import v14.h2.value.Value;
import v14.h2.value.ValueEnum;

public final class ExtTypeInfoEnum
extends ExtTypeInfo {
    private final String[] enumerators;
    private final String[] cleaned;
    private TypeInfo type;

    public static ExtTypeInfoEnum getEnumeratorsForBinaryOperation(Value value, Value value2) {
        if (value.getValueType() == 25) {
            return ((ValueEnum)value).getEnumerators();
        }
        if (value2.getValueType() == 25) {
            return ((ValueEnum)value2).getEnumerators();
        }
        throw DbException.get(50004, "type1=" + value.getValueType() + ", type2=" + value2.getValueType());
    }

    private static String sanitize(String string) {
        return string == null ? null : string.trim().toUpperCase(Locale.ENGLISH);
    }

    private static String toSQL(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append('\'');
            String string = stringArray[i];
            int n = string.length();
            for (int j = 0; j < n; ++j) {
                char c = string.charAt(j);
                if (c == '\'') {
                    stringBuilder.append('\'');
                }
                stringBuilder.append(c);
            }
            stringBuilder.append('\'');
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public ExtTypeInfoEnum(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw DbException.get(22032);
        }
        Object[] objectArray = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = ExtTypeInfoEnum.sanitize(stringArray[i]);
            if (string == null || string.isEmpty()) {
                throw DbException.get(22032);
            }
            for (int j = 0; j < i; ++j) {
                if (!string.equals(objectArray[j])) continue;
                throw DbException.get(22033, ExtTypeInfoEnum.toSQL(stringArray));
            }
            objectArray[i] = string;
        }
        this.enumerators = stringArray;
        this.cleaned = Arrays.equals(objectArray, stringArray) ? stringArray : objectArray;
    }

    TypeInfo getType() {
        TypeInfo typeInfo = this.type;
        if (typeInfo == null) {
            int n = 0;
            for (String string : this.enumerators) {
                int n2 = string.length();
                if (n2 <= n) continue;
                n = n2;
            }
            this.type = typeInfo = new TypeInfo(25, n, 0, n, this);
        }
        return typeInfo;
    }

    @Override
    public Value cast(Value value) {
        Object object;
        switch (value.getValueType()) {
            case 25: {
                if (value instanceof ValueEnum && ((ValueEnum)value).getEnumerators().equals(this)) {
                    return value;
                }
            }
            case 13: 
            case 14: 
            case 21: {
                object = this.getValueOrNull(value.getString());
                if (object == null) break;
                return object;
            }
            default: {
                int n = value.getInt();
                if (n < 0 || n >= this.enumerators.length) break;
                return new ValueEnum(this, this.enumerators[n], n);
            }
        }
        if (((String)(object = value.getTraceSQL())).length() > 127) {
            object = ((String)object).substring(0, 128) + "...";
        }
        throw DbException.get(22030, new String[]{this.toString(), object});
    }

    public String getEnumerator(int n) {
        return this.enumerators[n];
    }

    public ValueEnum getValue(int n) {
        if (n < 0 || n >= this.enumerators.length) {
            throw DbException.get(22030, this.enumerators.toString(), Integer.toString(n));
        }
        return new ValueEnum(this, this.enumerators[n], n);
    }

    public ValueEnum getValue(String string) {
        ValueEnum valueEnum = this.getValueOrNull(string);
        if (valueEnum == null) {
            throw DbException.get(22030, this.toString(), string);
        }
        return valueEnum;
    }

    private ValueEnum getValueOrNull(String string) {
        String string2 = ExtTypeInfoEnum.sanitize(string);
        if (string2 != null) {
            for (int i = 0; i < this.cleaned.length; ++i) {
                if (!string2.equals(this.cleaned[i])) continue;
                return new ValueEnum(this, this.enumerators[i], i);
            }
        }
        return null;
    }

    public int hashCode() {
        return Arrays.hashCode(this.enumerators) + 203117;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != ExtTypeInfoEnum.class) {
            return false;
        }
        return Arrays.equals(this.enumerators, ((ExtTypeInfoEnum)object).enumerators);
    }

    @Override
    public String getCreateSQL() {
        return ExtTypeInfoEnum.toSQL(this.enumerators);
    }
}

