/*
 * Decompiled with CFR 0.152.
 */
package v14.h2.value;

import java.nio.charset.Charset;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Comparator;

public class CharsetCollator
extends Collator {
    static final Comparator<byte[]> COMPARATOR = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] byArray, byte[] byArray2) {
            int n = Math.min(byArray.length, byArray2.length);
            for (int i = 0; i < n; ++i) {
                int n2 = byArray[i] - byArray2[i];
                if (n2 == 0) continue;
                return n2;
            }
            return byArray.length - byArray2.length;
        }
    };
    private final Charset charset;

    public CharsetCollator(Charset charset) {
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public int compare(String string, String string2) {
        return COMPARATOR.compare(this.toBytes(string), this.toBytes(string2));
    }

    byte[] toBytes(String string) {
        return string.getBytes(this.charset);
    }

    @Override
    public CollationKey getCollationKey(String string) {
        return new CharsetCollationKey(string);
    }

    @Override
    public int hashCode() {
        return 255;
    }

    private class CharsetCollationKey
    extends CollationKey {
        CharsetCollationKey(String string) {
            super(string);
        }

        @Override
        public int compareTo(CollationKey collationKey) {
            return COMPARATOR.compare(this.toByteArray(), CharsetCollator.this.toBytes(collationKey.getSourceString()));
        }

        @Override
        public byte[] toByteArray() {
            return CharsetCollator.this.toBytes(this.getSourceString());
        }
    }
}

