/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.protocol.component.api;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.nifi.c2.protocol.component.api.BuildInfo;
import org.apache.nifi.c2.protocol.component.api.DefinedType;
import org.apache.nifi.c2.protocol.component.api.Restriction;
import org.apache.nifi.c2.protocol.component.api.Stateful;
import org.apache.nifi.c2.protocol.component.api.SystemResourceConsideration;

@ApiModel
public class ExtensionComponent
extends DefinedType {
    private static final long serialVersionUID = 1L;
    private BuildInfo buildInfo;
    private List<DefinedType> providedApiImplementations;
    private Set<String> tags;
    private Set<String> seeAlso;
    private Boolean deprecated;
    private String deprecationReason;
    private Set<String> deprecationAlternatives;
    private Boolean restricted;
    private String restrictedExplanation;
    private Set<Restriction> explicitRestrictions;
    private Stateful stateful;
    private List<SystemResourceConsideration> systemResourceConsiderations;
    private boolean additionalDetails;

    @ApiModelProperty(value="The build metadata for this component")
    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public void setBuildInfo(BuildInfo buildInfo) {
        this.buildInfo = buildInfo;
    }

    @ApiModelProperty(value="If this type represents a provider for an interface, this lists the APIs it implements")
    public List<DefinedType> getProvidedApiImplementations() {
        return this.providedApiImplementations != null ? Collections.unmodifiableList(this.providedApiImplementations) : null;
    }

    public void setProvidedApiImplementations(List<DefinedType> providedApiImplementations) {
        this.providedApiImplementations = providedApiImplementations;
    }

    @ApiModelProperty(value="The tags associated with this type")
    public Set<String> getTags() {
        return this.tags != null ? Collections.unmodifiableSet(this.tags) : null;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    @ApiModelProperty(value="The names of other component types that may be related")
    public Set<String> getSeeAlso() {
        return this.seeAlso;
    }

    public void setSeeAlso(Set<String> seeAlso) {
        this.seeAlso = seeAlso;
    }

    @ApiModelProperty(value="Whether or not the component has been deprecated")
    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    @ApiModelProperty(value="If this component has been deprecated, this optional field can be used to provide an explanation")
    public String getDeprecationReason() {
        return this.deprecationReason;
    }

    public void setDeprecationReason(String deprecationReason) {
        this.deprecationReason = deprecationReason;
    }

    @ApiModelProperty(value="If this component has been deprecated, this optional field provides alternatives to use")
    public Set<String> getDeprecationAlternatives() {
        return this.deprecationAlternatives;
    }

    public void setDeprecationAlternatives(Set<String> deprecationAlternatives) {
        this.deprecationAlternatives = deprecationAlternatives;
    }

    @ApiModelProperty(value="Whether or not the component has a general restriction")
    public Boolean isRestricted() {
        return this.restricted;
    }

    public Boolean getRestricted() {
        return this.restricted;
    }

    public void setRestricted(Boolean restricted) {
        this.restricted = restricted;
    }

    @ApiModelProperty(value="An optional description of the general restriction")
    public String getRestrictedExplanation() {
        return this.restrictedExplanation;
    }

    public void setRestrictedExplanation(String restrictedExplanation) {
        this.restrictedExplanation = restrictedExplanation;
    }

    @ApiModelProperty(value="Explicit restrictions that indicate a require permission to use the component")
    public Set<Restriction> getExplicitRestrictions() {
        return this.explicitRestrictions;
    }

    public void setExplicitRestrictions(Set<Restriction> explicitRestrictions) {
        this.explicitRestrictions = explicitRestrictions;
    }

    @ApiModelProperty(value="Indicates if the component stores state")
    public Stateful getStateful() {
        return this.stateful;
    }

    public void setStateful(Stateful stateful) {
        this.stateful = stateful;
    }

    @ApiModelProperty(value="The system resource considerations for the given component")
    public List<SystemResourceConsideration> getSystemResourceConsiderations() {
        return this.systemResourceConsiderations;
    }

    public void setSystemResourceConsiderations(List<SystemResourceConsideration> systemResourceConsiderations) {
        this.systemResourceConsiderations = systemResourceConsiderations;
    }

    @ApiModelProperty(value="Indicates if the component has additional details documentation")
    public boolean isAdditionalDetails() {
        return this.additionalDetails;
    }

    public void setAdditionalDetails(boolean additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionComponent that = (ExtensionComponent)o;
        return super.equals(o) && Objects.equals(this.buildInfo, that.buildInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.buildInfo);
    }
}

