/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.fastdouble;

import io.questdb.std.NumericException;
import io.questdb.std.fastdouble.FastDoubleSwar;
import io.questdb.std.fastdouble.FastDoubleUtils;
import io.questdb.std.fastdouble.FastFloatMath;

final class FastFloatCharArray {
    FastFloatCharArray() {
    }

    private static float fallbackToJavaParser(char[] str, int startIndex, int endIndex, boolean rejectOverflow) throws NumericException {
        float f = Float.parseFloat(new String(str, startIndex, endIndex - startIndex));
        if (rejectOverflow && (f == Float.POSITIVE_INFINITY || f == Float.NEGATIVE_INFINITY || f == 0.0f)) {
            throw NumericException.INSTANCE;
        }
        return f;
    }

    private static boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    private static float parseDecFloatLiteral(char[] str, int index, int startIndex, int endIndex, boolean isNegative, boolean hasLeadingZero, boolean rejectOverflow) throws NumericException {
        int exponentOfTruncatedSignificand;
        boolean isSignificandTruncated;
        int exponent;
        int digitCount;
        long significand = 0L;
        int significandStartIndex = index;
        int virtualIndexOfPoint = -1;
        boolean illegal = false;
        char ch = '\u0000';
        while (index < endIndex) {
            ch = str[index];
            if (FastFloatCharArray.isDigit(ch)) {
                significand = 10L * significand + (long)ch - 48L;
            } else {
                int eightDigits;
                if (ch != '.') break;
                illegal |= virtualIndexOfPoint >= 0;
                virtualIndexOfPoint = index;
                while (index < endIndex - 8 && (eightDigits = FastFloatCharArray.tryToParseEightDigits(str, index + 1)) >= 0) {
                    significand = 100000000L * significand + (long)eightDigits;
                    index += 8;
                }
            }
            ++index;
        }
        int significandEndIndex = index;
        if (virtualIndexOfPoint < 0) {
            digitCount = index - significandStartIndex;
            virtualIndexOfPoint = index;
            exponent = 0;
        } else {
            digitCount = index - significandStartIndex - 1;
            exponent = virtualIndexOfPoint - index + 1;
        }
        int expNumber = 0;
        if (ch == 'e' || ch == 'E') {
            boolean neg_exp;
            ch = ++index < endIndex ? str[index] : (char)'\u0000';
            boolean bl = neg_exp = ch == '-';
            if (neg_exp || ch == '+') {
                ch = ++index < endIndex ? str[index] : (char)'\u0000';
            }
            illegal |= !FastFloatCharArray.isDigit(ch);
            do {
                if (expNumber >= 1024) continue;
                expNumber = 10 * expNumber + ch - 48;
            } while (FastFloatCharArray.isDigit(ch = ++index < endIndex ? str[index] : (char)'\u0000'));
            if (neg_exp) {
                expNumber = -expNumber;
            }
            exponent += expNumber;
        }
        if (index < endIndex && (ch == 'd' || ch == 'D' || ch == 'f' || ch == 'F')) {
            ++index;
        }
        index = FastFloatCharArray.skipWhitespace(str, index, endIndex);
        if (illegal || index < endIndex || !hasLeadingZero && digitCount == 0) {
            throw NumericException.INSTANCE;
        }
        int skipCountInTruncatedDigits = 0;
        if (digitCount > 19) {
            significand = 0L;
            for (index = significandStartIndex; index < significandEndIndex; ++index) {
                ch = str[index];
                if (ch == '.') {
                    ++skipCountInTruncatedDigits;
                    continue;
                }
                if (Long.compareUnsigned(significand, 1000000000000000000L) >= 0) break;
                significand = 10L * significand + (long)ch - 48L;
            }
            isSignificandTruncated = index < significandEndIndex;
            exponentOfTruncatedSignificand = virtualIndexOfPoint - index + skipCountInTruncatedDigits + expNumber;
        } else {
            isSignificandTruncated = false;
            exponentOfTruncatedSignificand = 0;
        }
        return FastFloatCharArray.valueOfFloatLiteral(str, startIndex, endIndex, isNegative, significand, exponent, isSignificandTruncated, exponentOfTruncatedSignificand, rejectOverflow);
    }

    private static float parseHexFloatLiteral(char[] str, int index, int startIndex, int endIndex, boolean isNegative, boolean rejectOverflow) throws NumericException {
        boolean isSignificandTruncated;
        boolean hasExponent;
        int digitCount;
        long significand = 0L;
        int exponent = 0;
        int significandStartIndex = index;
        int virtualIndexOfPoint = -1;
        boolean illegal = false;
        char ch = '\u0000';
        while (index < endIndex) {
            int hexValue;
            ch = str[index];
            int n = hexValue = ch > '\u007f' ? -1 : FastDoubleUtils.CHAR_TO_HEX_MAP[ch];
            if (hexValue >= 0) {
                significand = significand << 4 | (long)hexValue;
            } else {
                if (hexValue != -4) break;
                illegal |= virtualIndexOfPoint >= 0;
                virtualIndexOfPoint = index;
            }
            ++index;
        }
        int significandEndIndex = index;
        if (virtualIndexOfPoint < 0) {
            digitCount = significandEndIndex - significandStartIndex;
            virtualIndexOfPoint = significandEndIndex;
        } else {
            digitCount = significandEndIndex - significandStartIndex - 1;
            exponent = Math.min(virtualIndexOfPoint - index + 1, 1024) * 4;
        }
        int expNumber = 0;
        boolean bl = hasExponent = ch == 'p' || ch == 'P';
        if (hasExponent) {
            boolean neg_exp;
            ch = ++index < endIndex ? str[index] : (char)'\u0000';
            boolean bl2 = neg_exp = ch == '-';
            if (neg_exp || ch == '+') {
                ch = ++index < endIndex ? str[index] : (char)'\u0000';
            }
            illegal |= !FastFloatCharArray.isDigit(ch);
            do {
                expNumber = 10 * expNumber + ch - 48;
            } while (FastFloatCharArray.isDigit(ch = ++index < endIndex ? str[index] : (char)'\u0000'));
            if (neg_exp) {
                expNumber = -expNumber;
            }
            exponent += expNumber;
        }
        if (index < endIndex && (ch == 'd' || ch == 'D' || ch == 'f' || ch == 'F')) {
            ++index;
        }
        index = FastFloatCharArray.skipWhitespace(str, index, endIndex);
        if (illegal || index < endIndex || digitCount == 0 || !hasExponent) {
            throw NumericException.INSTANCE;
        }
        int skipCountInTruncatedDigits = 0;
        if (digitCount > 16) {
            significand = 0L;
            for (index = significandStartIndex; index < significandEndIndex; ++index) {
                int hexValue;
                ch = str[index];
                int n = hexValue = ch > '\u007f' ? -1 : FastDoubleUtils.CHAR_TO_HEX_MAP[ch];
                if (hexValue >= 0) {
                    if (Long.compareUnsigned(significand, 1000000000000000000L) >= 0) break;
                    significand = significand << 4 | (long)hexValue;
                    continue;
                }
                ++skipCountInTruncatedDigits;
            }
            isSignificandTruncated = index < significandEndIndex;
        } else {
            isSignificandTruncated = false;
        }
        return FastFloatCharArray.valueOfHexLiteral(str, startIndex, endIndex, isNegative, significand, exponent, isSignificandTruncated, virtualIndexOfPoint - index + skipCountInTruncatedDigits + expNumber, rejectOverflow);
    }

    private static float parseInfinity(char[] str, int index, int endIndex, boolean negative) throws NumericException {
        if (index + 7 < endIndex && str[index] == 'I' && str[index + 1] == 'n' && str[index + 2] == 'f' && str[index + 3] == 'i' && str[index + 4] == 'n' && str[index + 5] == 'i' && str[index + 6] == 't' && str[index + 7] == 'y' && (index = FastFloatCharArray.skipWhitespace(str, index + 8, endIndex)) == endIndex) {
            return negative ? FastFloatCharArray.negativeInfinity() : FastFloatCharArray.positiveInfinity();
        }
        throw NumericException.INSTANCE;
    }

    private static float parseNaN(char[] str, int index, int endIndex) throws NumericException {
        if (index + 2 < endIndex && str[index + 1] == 'a' && str[index + 2] == 'N' && (index = FastFloatCharArray.skipWhitespace(str, index + 3, endIndex)) == endIndex) {
            return FastFloatCharArray.nan();
        }
        throw NumericException.INSTANCE;
    }

    private static int skipWhitespace(char[] str, int index, int endIndex) {
        while (index < endIndex && (str[index] & 0xFF) <= 32) {
            ++index;
        }
        return index;
    }

    private static int tryToParseEightDigits(char[] str, int offset) {
        return FastDoubleSwar.tryToParseEightDigitsUtf16(str, offset);
    }

    static float nan() {
        return Float.NaN;
    }

    static float negativeInfinity() {
        return Float.NEGATIVE_INFINITY;
    }

    static float parseFloatingPointLiteral(char[] str, int offset, int length, boolean rejectOverflow) throws NumericException {
        boolean hasLeadingZero;
        boolean isNegative;
        int endIndex = offset + length;
        if (offset < 0 || endIndex > str.length) {
            throw NumericException.INSTANCE;
        }
        int index = FastFloatCharArray.skipWhitespace(str, offset, endIndex);
        if (index == endIndex) {
            throw NumericException.INSTANCE;
        }
        char ch = str[index];
        boolean bl = isNegative = ch == '-';
        if (isNegative || ch == '+') {
            char c = ch = ++index < endIndex ? str[index] : (char)'\u0000';
            if (ch == '\u0000') {
                throw NumericException.INSTANCE;
            }
        }
        if (ch >= 'I') {
            return ch == 'N' ? FastFloatCharArray.parseNaN(str, index, endIndex) : FastFloatCharArray.parseInfinity(str, index, endIndex, isNegative);
        }
        boolean bl2 = hasLeadingZero = ch == '0';
        if (hasLeadingZero) {
            char c = ch = ++index < endIndex ? str[index] : (char)'\u0000';
            if (ch == 'x' || ch == 'X') {
                return FastFloatCharArray.parseHexFloatLiteral(str, index + 1, offset, endIndex, isNegative, rejectOverflow);
            }
        }
        return FastFloatCharArray.parseDecFloatLiteral(str, index, offset, endIndex, isNegative, hasLeadingZero, rejectOverflow);
    }

    static float positiveInfinity() {
        return Float.POSITIVE_INFINITY;
    }

    static float valueOfFloatLiteral(char[] str, int startIndex, int endIndex, boolean isNegative, long significand, int exponent, boolean isSignificandTruncated, int exponentOfTruncatedSignificand, boolean rejectOverflow) throws NumericException {
        float f = FastFloatMath.decFloatLiteralToFloat(isNegative, significand, exponent, isSignificandTruncated, exponentOfTruncatedSignificand);
        if (Float.isNaN(f)) {
            f = FastFloatCharArray.fallbackToJavaParser(str, startIndex, endIndex, rejectOverflow);
        }
        return f;
    }

    static float valueOfHexLiteral(char[] str, int startIndex, int endIndex, boolean isNegative, long significand, int exponent, boolean isSignificandTruncated, int exponentOfTruncatedSignificand, boolean rejectOverflow) throws NumericException {
        float f = FastFloatMath.hexFloatLiteralToFloat(isNegative, significand, exponent, isSignificandTruncated, exponentOfTruncatedSignificand);
        if (Float.isNaN(f)) {
            f = FastFloatCharArray.fallbackToJavaParser(str, startIndex, endIndex, rejectOverflow);
        }
        return f;
    }
}

