/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.cairo.CairoException;
import io.questdb.griffin.engine.functions.constants.CharConstant;
import io.questdb.griffin.engine.functions.str.TrimType;
import io.questdb.std.BinarySequence;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.str.ByteCharSequence;
import io.questdb.std.str.ByteSequence;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.CharSinkBase;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.MutableCharSink;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Chars {
    static final char[] base64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();

    private Chars() {
    }

    public static void asciiCopyTo(char[] chars, int start, int len, long dest) {
        for (int i = 0; i < len; ++i) {
            Unsafe.getUnsafe().putByte(dest + (long)i, (byte)chars[i + start]);
        }
    }

    public static long asciiStrCpy(CharSequence value, long address) {
        Chars.asciiStrCpy(value, value.length(), address);
        return address;
    }

    public static void asciiStrCpy(CharSequence value, int len, long address) {
        for (int i = 0; i < len; ++i) {
            Unsafe.getUnsafe().putByte(address + (long)i, (byte)value.charAt(i));
        }
    }

    public static void asciiStrCpy(CharSequence value, int lo, int len, long address) {
        for (int i = 0; i < len; ++i) {
            Unsafe.getUnsafe().putByte(address + (long)i, (byte)value.charAt(lo + i));
        }
    }

    public static void base64Encode(BinarySequence sequence, int maxLength, CharSink buffer) {
        if (sequence == null) {
            return;
        }
        long len = Math.min((long)maxLength, sequence.length());
        int pad = 0;
        int i = 0;
        while ((long)i < len) {
            int b = (sequence.byteAt(i) & 0xFF) << 16 & 0xFFFFFF;
            if ((long)(i + 1) < len) {
                b |= (sequence.byteAt(i + 1) & 0xFF) << 8;
            } else {
                ++pad;
            }
            if ((long)(i + 2) < len) {
                b |= sequence.byteAt(i + 2) & 0xFF;
            } else {
                ++pad;
            }
            for (int j = 0; j < 4 - pad; ++j) {
                int c = (b & 0xFC0000) >> 18;
                buffer.put(base64[c]);
                b <<= 6;
            }
            i += 3;
        }
        for (int j = 0; j < pad; ++j) {
            buffer.put("=");
        }
    }

    public static int compare(CharSequence l, CharSequence r) {
        if (l == r) {
            return 0;
        }
        if (l == null) {
            return -1;
        }
        if (r == null) {
            return 1;
        }
        int ll = l.length();
        int rl = r.length();
        int min = Math.min(ll, rl);
        for (int i = 0; i < min; ++i) {
            int k = l.charAt(i) - r.charAt(i);
            if (k == 0) continue;
            return k;
        }
        return Integer.compare(ll, rl);
    }

    public static int compareDescending(CharSequence l, CharSequence r) {
        return Chars.compare(r, l);
    }

    public static boolean contains(CharSequence sequence, CharSequence term) {
        return Chars.indexOf(sequence, 0, sequence.length(), term) != -1;
    }

    public static void copyStrChars(CharSequence value, int pos, int len, long address) {
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i + pos);
            Unsafe.getUnsafe().putChar(address + 2L * (long)i, c);
        }
    }

    public static boolean empty(@Nullable CharSequence value) {
        return value == null || value.length() < 1;
    }

    public static boolean endsWith(CharSequence cs, CharSequence ends) {
        if (ends == null || cs == null) {
            return false;
        }
        int l = ends.length();
        if (l == 0) {
            return false;
        }
        int csl = cs.length();
        return csl != 0 && csl >= l && Chars.equals(ends, cs, csl - l, csl);
    }

    public static boolean endsWith(CharSequence cs, char c) {
        if (cs == null) {
            return false;
        }
        int csl = cs.length();
        return csl != 0 && c == cs.charAt(csl - 1);
    }

    public static boolean equals(@NotNull CharSequence l, @NotNull CharSequence r) {
        if (l == r) {
            return true;
        }
        int ll = l.length();
        if (ll != r.length()) {
            return false;
        }
        return Chars.equalsChars(l, r, ll);
    }

    public static boolean equals(@NotNull ByteCharSequence l, @NotNull ByteCharSequence r) {
        if (l == r) {
            return true;
        }
        int ll = l.length();
        if (ll != r.length()) {
            return false;
        }
        return Chars.equalsChars(l, r, ll);
    }

    public static boolean equals(@NotNull String l, @NotNull String r) {
        return l.equals(r);
    }

    public static boolean equals(@NotNull DirectByteCharSequence l, @NotNull String r) {
        int ll = l.length();
        if (ll != r.length()) {
            return false;
        }
        return Chars.equalsChars(l, r, ll);
    }

    public static boolean equals(@NotNull DirectByteCharSequence l, @NotNull ByteCharSequence r) {
        int ll = l.length();
        if (ll != r.length()) {
            return false;
        }
        return Chars.equalsChars(l, r, ll);
    }

    public static boolean equals(@NotNull CharSequence l, @NotNull CharSequence r, int rLo, int rHi) {
        if (l == r) {
            return true;
        }
        int ll = l.length();
        if (ll != rHi - rLo) {
            return false;
        }
        for (int i = 0; i < ll; ++i) {
            if (l.charAt(i) == r.charAt(i + rLo)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(@NotNull CharSequence l, int lLo, int lHi, @NotNull CharSequence r, int rLo, int rHi) {
        if (l == r) {
            return true;
        }
        int ll = lHi - lLo;
        if (ll != rHi - rLo) {
            return false;
        }
        for (int i = 0; i < ll; ++i) {
            if (l.charAt(i + lLo) == r.charAt(i + rLo)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(@NotNull CharSequence l, char r) {
        return l.length() == 1 && l.charAt(0) == r;
    }

    public static boolean equalsIgnoreCase(@NotNull CharSequence l, @NotNull CharSequence r) {
        if (l == r) {
            return true;
        }
        int ll = l.length();
        if (ll != r.length()) {
            return false;
        }
        for (int i = 0; i < ll; ++i) {
            if (Character.toLowerCase(l.charAt(i)) == Character.toLowerCase(r.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreCaseNc(@NotNull CharSequence l, @Nullable CharSequence r) {
        return r != null && Chars.equalsIgnoreCase(l, r);
    }

    public static boolean equalsLowerCase(@NotNull CharSequence l, int lLo, int lHi, @NotNull CharSequence r, int rLo, int rHi) {
        if (l == r) {
            return true;
        }
        int ll = lHi - lLo;
        if (ll != rHi - rLo) {
            return false;
        }
        for (int i = 0; i < ll; ++i) {
            if (Character.toLowerCase(l.charAt(i + lLo)) == Character.toLowerCase(r.charAt(i + rLo))) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsLowerCaseAscii(@NotNull CharSequence l, int lLo, int lHi, @NotNull CharSequence r, int rLo, int rHi) {
        if (l == r) {
            return true;
        }
        int ll = lHi - lLo;
        if (ll != rHi - rLo) {
            return false;
        }
        for (int i = 0; i < ll; ++i) {
            if (Chars.toLowerCaseAscii(l.charAt(i + lLo)) == Chars.toLowerCaseAscii(r.charAt(i + rLo))) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsLowerCaseAscii(@NotNull CharSequence l, @NotNull CharSequence r) {
        int ll = l.length();
        if (ll != r.length()) {
            return false;
        }
        for (int i = 0; i < ll; ++i) {
            if (Chars.toLowerCaseAscii(l.charAt(i)) == Chars.toLowerCaseAscii(r.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsLowerCaseAsciiNc(@NotNull CharSequence l, @Nullable CharSequence r) {
        return r != null && Chars.equalsLowerCaseAscii(l, r);
    }

    public static boolean equalsNc(@Nullable CharSequence l, char r) {
        return l == null && r == CharConstant.ZERO.getChar(null) || l != null && Chars.equals(l, r);
    }

    public static boolean equalsNc(@NotNull CharSequence l, @Nullable CharSequence r) {
        return r != null && Chars.equals(l, r);
    }

    public static int hashCode(@NotNull CharSequence value, int lo, int hi) {
        if (hi == lo) {
            return 0;
        }
        int h = 0;
        for (int p = lo; p < hi; ++p) {
            h = 31 * h + value.charAt(p);
        }
        return h;
    }

    public static int hashCode(@NotNull CharSequence value) {
        if (value instanceof String) {
            return value.hashCode();
        }
        int len = value.length();
        if (len == 0) {
            return 0;
        }
        int h = 0;
        for (int p = 0; p < len; ++p) {
            h = 31 * h + value.charAt(p);
        }
        return h;
    }

    public static int hashCode(@NotNull String value) {
        return value.hashCode();
    }

    public static int hashCode(@NotNull DirectByteCharSequence value) {
        int len = value.length();
        if (len == 0) {
            return 0;
        }
        int h = 0;
        for (int p = 0; p < len; ++p) {
            h = 31 * h + value.charAt(p);
        }
        return h;
    }

    public static int indexOf(CharSequence sequence, int sequenceLo, int sequenceHi, CharSequence term) {
        return Chars.indexOf(sequence, sequenceLo, sequenceHi, term, 1);
    }

    public static int indexOf(CharSequence sequence, int sequenceLo, int sequenceHi, CharSequence term, int occurrence) {
        int m = term.length();
        if (m == 0) {
            return -1;
        }
        if (occurrence == 0) {
            return -1;
        }
        int foundIndex = -1;
        int count = 0;
        if (occurrence > 0) {
            for (int i = sequenceLo; i < sequenceHi; ++i) {
                if (foundIndex == -1) {
                    if (sequenceHi - i < m) {
                        return -1;
                    }
                    if (sequence.charAt(i) == term.charAt(0)) {
                        foundIndex = i;
                    }
                } else if (sequence.charAt(i) != term.charAt(i - foundIndex)) {
                    i = foundIndex;
                    foundIndex = -1;
                }
                if (foundIndex == -1 || i - foundIndex != m - 1) continue;
                if (++count == occurrence) {
                    return foundIndex;
                }
                foundIndex = -1;
            }
        } else {
            for (int i = sequenceHi - 1; i >= sequenceLo; --i) {
                if (foundIndex == -1) {
                    if (i - sequenceLo + 1 < m) {
                        return -1;
                    }
                    if (sequence.charAt(i) == term.charAt(m - 1)) {
                        foundIndex = i;
                    }
                } else if (sequence.charAt(i) != term.charAt(m - 1 + i - foundIndex)) {
                    i = foundIndex;
                    foundIndex = -1;
                }
                if (foundIndex == -1 || foundIndex - i != m - 1) continue;
                if (--count == occurrence) {
                    return foundIndex + 1 - m;
                }
                foundIndex = -1;
            }
        }
        return -1;
    }

    public static int indexOf(CharSequence s, char c) {
        return Chars.indexOf(s, 0, c);
    }

    public static int indexOf(CharSequence s, int lo, char c) {
        return Chars.indexOf(s, lo, s.length(), c);
    }

    public static int indexOf(CharSequence s, int lo, int hi, char c) {
        return Chars.indexOf(s, lo, hi, c, 1);
    }

    public static int indexOf(CharSequence sequence, int sequenceLo, int sequenceHi, char ch, int occurrence) {
        if (occurrence == 0) {
            return -1;
        }
        int count = 0;
        if (occurrence > 0) {
            for (int i = sequenceLo; i < sequenceHi; ++i) {
                if (sequence.charAt(i) != ch || ++count != occurrence) continue;
                return i;
            }
        } else {
            for (int i = sequenceHi - 1; i >= sequenceLo; --i) {
                if (sequence.charAt(i) != ch || --count != occurrence) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean isBlank(CharSequence s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace((int)c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isMalformed3(int b1, int b2, int b3) {
        return b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128;
    }

    public static boolean isMalformed4(int b2, int b3, int b4) {
        return (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128;
    }

    public static boolean isNotContinuation(int b) {
        return (b & 0xC0) != 128;
    }

    public static boolean isOnlyDecimals(CharSequence s) {
        int len = s.length();
        for (int i = len - 1; i > -1; --i) {
            char digit = s.charAt(i);
            if (digit >= '0' && digit <= '9') continue;
            return false;
        }
        return len > 0;
    }

    public static boolean isQuote(char c) {
        switch (c) {
            case '\"': 
            case '\'': 
            case '`': {
                return true;
            }
        }
        return false;
    }

    public static boolean isQuoted(CharSequence s) {
        if (s == null || s.length() < 2) {
            return false;
        }
        char open = s.charAt(0);
        return Chars.isQuote(open) && open == s.charAt(s.length() - 1);
    }

    public static int lastIndexOf(CharSequence s, char c) {
        for (int i = s.length() - 1; i > -1; --i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static int lowerCaseAsciiHashCode(CharSequence value, int lo, int hi) {
        if (hi == lo) {
            return 0;
        }
        int h = 0;
        for (int p = lo; p < hi; ++p) {
            h = 31 * h + Chars.toLowerCaseAscii(value.charAt(p));
        }
        return h;
    }

    public static int lowerCaseAsciiHashCode(CharSequence value) {
        int len = value.length();
        if (len == 0) {
            return 0;
        }
        int h = 0;
        for (int p = 0; p < len; ++p) {
            h = 31 * h + Chars.toLowerCaseAscii(value.charAt(p));
        }
        return h;
    }

    public static int lowerCaseHashCode(CharSequence value, int lo, int hi) {
        if (hi == lo) {
            return 0;
        }
        int h = 0;
        for (int p = lo; p < hi; ++p) {
            h = 31 * h + Character.toLowerCase(value.charAt(p));
        }
        return h;
    }

    public static int lowerCaseHashCode(CharSequence value) {
        int len = value.length();
        if (len == 0) {
            return 0;
        }
        int h = 0;
        for (int p = 0; p < len; ++p) {
            h = 31 * h + Character.toLowerCase(value.charAt(p));
        }
        return h;
    }

    public static boolean noMatch(CharSequence l, int llo, int lhi, CharSequence r, int rlo, int rhi) {
        int lp = llo;
        int rp = rlo;
        while (lp < lhi && rp < rhi) {
            if (Character.toLowerCase(l.charAt(lp++)) == r.charAt(rp++)) continue;
            return true;
        }
        return lp != lhi || rp != rhi;
    }

    public static CharSequence repeat(final String s, final int times) {
        return new CharSequence(){

            @Override
            public char charAt(int index) {
                return s.charAt(index % s.length());
            }

            @Override
            public int length() {
                return s.length() * times;
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static ObjList<Path> splitLpsz(CharSequence args) {
        ObjList<Path> paths = new ObjList<Path>();
        int n = args.length();
        int lastLen = 0;
        int lastIndex = 0;
        boolean inQuote = false;
        block4: for (int i = 0; i < n; ++i) {
            char b = args.charAt(i);
            switch (b) {
                case ' ': {
                    if (lastLen <= 0) continue block4;
                    if (inQuote) {
                        ++lastLen;
                        continue block4;
                    }
                    paths.add(new Path().of(args, lastIndex, lastLen + lastIndex).$());
                    lastLen = 0;
                    continue block4;
                }
                case '\"': {
                    inQuote = !inQuote;
                    continue block4;
                }
                default: {
                    if (lastLen == 0) {
                        lastIndex = i;
                    }
                    ++lastLen;
                }
            }
        }
        if (lastLen > 0) {
            paths.add(new Path().of(args, lastIndex, lastLen + lastIndex).$());
        }
        return paths;
    }

    public static boolean startsWith(CharSequence _this, CharSequence that) {
        int len = that.length();
        return _this.length() >= len && Chars.equalsChars(_this, that, len);
    }

    public static boolean startsWith(CharSequence _this, int thisLo, int thisHi, CharSequence that) {
        int thisLen = thisHi - thisLo;
        int len = that.length();
        if (thisLen < len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (_this.charAt(thisLo + i) == that.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(CharSequence _this, char c) {
        return _this.length() > 0 && _this.charAt(0) == c;
    }

    public static String stringFromUtf8Bytes(long lo, long hi) {
        if (hi == lo) {
            return "";
        }
        StringSink b = Misc.getThreadLocalBuilder();
        Chars.utf8Decode(lo, hi, b);
        return ((Object)b).toString();
    }

    public static String stringFromUtf8Bytes(ByteSequence seq) {
        if (seq.length() == 0) {
            return "";
        }
        StringSink b = Misc.getThreadLocalBuilder();
        Chars.utf8Decode(seq, b);
        return ((Object)b).toString();
    }

    public static void toLowerCase(@Nullable CharSequence str, CharSink sink) {
        if (str != null) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                sink.put(Character.toLowerCase(str.charAt(i)));
            }
        }
    }

    public static String toLowerCaseAscii(@Nullable CharSequence value) {
        if (value == null) {
            return null;
        }
        int len = value.length();
        if (len == 0) {
            return "";
        }
        StringSink b = Misc.getThreadLocalBuilder();
        for (int i = 0; i < len; ++i) {
            b.put(Chars.toLowerCaseAscii(value.charAt(i)));
        }
        return ((Object)b).toString();
    }

    public static char toLowerCaseAscii(char character) {
        return character > '@' && character < '[' ? (char)(character + 32) : character;
    }

    public static void toSink(BinarySequence sequence, CharSink sink) {
        if (sequence == null) {
            return;
        }
        int len = (int)sequence.length();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                if (i % 16 == 0) {
                    sink.put('\n');
                    Numbers.appendHexPadded(sink, i);
                }
            } else {
                Numbers.appendHexPadded(sink, i);
            }
            sink.put(' ');
            int b = sequence.byteAt(i);
            int v = b < 0 ? 256 + b : b;
            if (v < 16) {
                sink.put('0');
                sink.put(Numbers.hexDigits[b]);
                continue;
            }
            sink.put(Numbers.hexDigits[v / 16]);
            sink.put(Numbers.hexDigits[v % 16]);
        }
    }

    public static String toString(CharSequence s) {
        return s == null ? null : s.toString();
    }

    public static String toString(CharSequence cs, int start, int end) {
        StringSink b = Misc.getThreadLocalBuilder();
        b.put(cs, start, end);
        return ((Object)b).toString();
    }

    public static String toString(CharSequence cs, int start, int end, char unescape) {
        StringSink b = Misc.getThreadLocalBuilder();
        int lastChar = end - 1;
        for (int i = start; i < end; ++i) {
            char c = cs.charAt(i);
            b.put(c);
            if (c != unescape || i >= lastChar || cs.charAt(i + 1) != unescape) continue;
            ++i;
        }
        return ((Object)b).toString();
    }

    public static void toUpperCase(@Nullable CharSequence str, CharSink sink) {
        if (str != null) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                sink.put(Character.toUpperCase(str.charAt(i)));
            }
        }
    }

    public static void trim(TrimType type, CharSequence str, StringSink sink) {
        int startIdx;
        if (str == null) {
            return;
        }
        int endIdx = str.length() - 1;
        if (type == TrimType.LTRIM || type == TrimType.TRIM) {
            for (startIdx = 0; startIdx < endIdx && str.charAt(startIdx) == ' '; ++startIdx) {
            }
        }
        if (type == TrimType.RTRIM || type == TrimType.TRIM) {
            while (startIdx < endIdx && str.charAt(endIdx) == ' ') {
                --endIdx;
            }
        }
        sink.clear();
        if (startIdx != endIdx) {
            sink.put(str, startIdx, endIdx + 1);
        }
    }

    public static boolean utf8Decode(long lo, long hi, CharSinkBase sink) {
        long p = lo;
        while (p < hi) {
            byte b = Unsafe.getUnsafe().getByte(p);
            if (b < 0) {
                int n = Chars.utf8DecodeMultiByte(p, hi, (int)b, sink);
                if (n == -1) {
                    return false;
                }
                p += (long)n;
                continue;
            }
            sink.put((char)b);
            ++p;
        }
        return true;
    }

    public static boolean utf8Decode(ByteSequence seq, CharSinkBase sink) {
        int i = 0;
        int len = seq.length();
        while (i < len) {
            byte b = seq.byteAt(i);
            if (b < 0) {
                int n = Chars.utf8DecodeMultiByte(seq, i, (int)b, sink);
                if (n == -1) {
                    return false;
                }
                i += n;
                continue;
            }
            sink.put((char)b);
            ++i;
        }
        return true;
    }

    public static int utf8DecodeMultiByte(long lo, long hi, int b, CharSinkBase sink) {
        if (b >> 5 == -2 && (b & 0x1E) != 0) {
            return Chars.utf8Decode2Bytes(lo, hi, b, sink);
        }
        if (b >> 4 == -2) {
            return Chars.utf8Decode3Bytes(lo, hi, b, sink);
        }
        return Chars.utf8Decode4Bytes(lo, hi, b, sink);
    }

    public static int utf8DecodeMultiByte(ByteSequence seq, int index, int b, CharSinkBase sink) {
        if (b >> 5 == -2 && (b & 0x1E) != 0) {
            return Chars.utf8Decode2Bytes(seq, index, b, sink);
        }
        if (b >> 4 == -2) {
            return Chars.utf8Decode3Bytes(seq, index, b, sink);
        }
        return Chars.utf8Decode4Bytes(seq, index, b, sink);
    }

    public static int utf8DecodeMultiByteZ(long lo, int b, CharSink sink) {
        if (b >> 5 == -2 && (b & 0x1E) != 0) {
            return Chars.utf8Decode2BytesZ(lo, b, sink);
        }
        if (b >> 4 == -2) {
            return Chars.utf8Decode3BytesZ(lo, b, sink);
        }
        return Chars.utf8Decode4BytesZ(lo, b, sink);
    }

    public static boolean utf8DecodeZ(long lo, CharSink sink) {
        byte b;
        long p = lo;
        while ((b = Unsafe.getUnsafe().getByte(p)) != 0) {
            if (b < 0) {
                int n = Chars.utf8DecodeMultiByteZ(p, b, sink);
                if (n == -1) {
                    return false;
                }
                p += (long)n;
                continue;
            }
            sink.put((char)b);
            ++p;
        }
        return true;
    }

    public static CharSequence utf8ToUtf16(DirectByteCharSequence utf8CharSeq, MutableCharSink tempSink, boolean hasNonAsciiChars) {
        if (hasNonAsciiChars) {
            Chars.utf8ToUtf16Unchecked(utf8CharSeq, tempSink);
            return tempSink;
        }
        return utf8CharSeq;
    }

    public static void utf8ToUtf16Unchecked(DirectByteCharSequence utf8CharSeq, MutableCharSink tempSink) {
        tempSink.clear();
        if (!Chars.utf8Decode(utf8CharSeq.getLo(), utf8CharSeq.getHi(), tempSink)) {
            throw CairoException.nonCritical().put("invalid UTF8 in value for ").put(utf8CharSeq);
        }
    }

    private static boolean equalsChars(CharSequence l, CharSequence r, int len) {
        for (int i = 0; i < len; ++i) {
            if (l.charAt(i) == r.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsChars(DirectByteCharSequence l, String r, int len) {
        for (int i = 0; i < len; ++i) {
            if (l.charAt(i) == r.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsChars(DirectByteCharSequence l, ByteCharSequence r, int len) {
        long lo = l.getLo();
        int i = 0;
        while (i + 3 < len) {
            if (Unsafe.getUnsafe().getInt(lo + (long)i) != r.intAt(i)) {
                return false;
            }
            i += 4;
        }
        while (i < len) {
            if (Unsafe.getUnsafe().getByte(lo + (long)i) != r.byteAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean equalsChars(ByteCharSequence l, ByteCharSequence r, int len) {
        int i = 0;
        while (i + 3 < len) {
            if (l.intAt(i) != r.intAt(i)) {
                return false;
            }
            i += 4;
        }
        while (i < len) {
            if (l.byteAt(i) != r.byteAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static int utf8Decode2Bytes(ByteSequence seq, int index, int b1, CharSinkBase sink) {
        if (seq.length() - index < 2) {
            return Chars.utf8error();
        }
        byte b2 = Unsafe.getUnsafe().getByte(index + 1);
        if (Chars.isNotContinuation(b2)) {
            return Chars.utf8error();
        }
        sink.put((char)(b1 << 6 ^ b2 ^ 0xF80));
        return 2;
    }

    private static int utf8Decode2Bytes(long lo, long hi, int b1, CharSinkBase sink) {
        if (hi - lo < 2L) {
            return Chars.utf8error();
        }
        byte b2 = Unsafe.getUnsafe().getByte(lo + 1L);
        if (Chars.isNotContinuation(b2)) {
            return Chars.utf8error();
        }
        sink.put((char)(b1 << 6 ^ b2 ^ 0xF80));
        return 2;
    }

    public static int utf8CharDecode(long lo, long hi) {
        if (lo < hi) {
            byte b1 = Unsafe.getUnsafe().getByte(lo);
            if (b1 < 0) {
                if (b1 >> 5 == -2 && (b1 & 0x1E) != 0 && hi - lo > 1L) {
                    byte b2 = Unsafe.getUnsafe().getByte(lo + 1L);
                    if (Chars.isNotContinuation(b2)) {
                        return 0;
                    }
                    return Numbers.encodeLowHighShorts((short)2, (short)(b1 << 6 ^ b2 ^ 0xF80));
                }
                if (b1 >> 4 == -2 && hi - lo > 2L) {
                    byte b3;
                    byte b2 = Unsafe.getUnsafe().getByte(lo + 1L);
                    if (Chars.isMalformed3(b1, b2, b3 = Unsafe.getUnsafe().getByte(lo + 2L))) {
                        return 0;
                    }
                    char c = (char)(b1 << 12 ^ b2 << 6 ^ b3 ^ 0xFFFE1F80);
                    if (Character.isSurrogate(c)) {
                        return 0;
                    }
                    return Numbers.encodeLowHighShorts((short)3, (short)c);
                }
                return 0;
            }
            return Numbers.encodeLowHighShorts((short)1, b1);
        }
        return 0;
    }

    private static int utf8Decode2BytesZ(long lo, int b1, CharSink sink) {
        byte b2 = Unsafe.getUnsafe().getByte(lo + 1L);
        if (b2 == 0) {
            return Chars.utf8error();
        }
        if (Chars.isNotContinuation(b2)) {
            return Chars.utf8error();
        }
        sink.put((char)(b1 << 6 ^ b2 ^ 0xF80));
        return 2;
    }

    private static int utf8Decode3Byte0(int b1, CharSinkBase sink, byte b2, byte b3) {
        if (Chars.isMalformed3(b1, b2, b3)) {
            return Chars.utf8error();
        }
        char c = (char)(b1 << 12 ^ b2 << 6 ^ b3 ^ 0xFFFE1F80);
        if (Character.isSurrogate(c)) {
            return Chars.utf8error();
        }
        sink.put(c);
        return 3;
    }

    private static int utf8Decode3Bytes(long lo, long hi, int b1, CharSinkBase sink) {
        if (hi - lo < 3L) {
            return Chars.utf8error();
        }
        byte b2 = Unsafe.getUnsafe().getByte(lo + 1L);
        byte b3 = Unsafe.getUnsafe().getByte(lo + 2L);
        return Chars.utf8Decode3Byte0(b1, sink, b2, b3);
    }

    private static int utf8Decode3Bytes(ByteSequence seq, int index, int b1, CharSinkBase sink) {
        if (seq.length() - index < 3) {
            return Chars.utf8error();
        }
        byte b2 = Unsafe.getUnsafe().getByte(index + 1);
        byte b3 = Unsafe.getUnsafe().getByte(index + 2);
        return Chars.utf8Decode3Byte0(b1, sink, b2, b3);
    }

    private static int utf8Decode3BytesZ(long lo, int b1, CharSink sink) {
        byte b2 = Unsafe.getUnsafe().getByte(lo + 1L);
        if (b2 == 0) {
            return Chars.utf8error();
        }
        byte b3 = Unsafe.getUnsafe().getByte(lo + 2L);
        if (b3 == 0) {
            return Chars.utf8error();
        }
        return Chars.utf8Decode3Byte0(b1, sink, b2, b3);
    }

    private static int utf8Decode4Bytes(long lo, long hi, int b, CharSinkBase sink) {
        if (b >> 3 != -2 || hi - lo < 4L) {
            return Chars.utf8error();
        }
        byte b2 = Unsafe.getUnsafe().getByte(lo + 1L);
        byte b3 = Unsafe.getUnsafe().getByte(lo + 2L);
        byte b4 = Unsafe.getUnsafe().getByte(lo + 3L);
        return Chars.utf8Decode4Bytes0(b, sink, b2, b3, b4);
    }

    private static int utf8Decode4Bytes(ByteSequence seq, int index, int b, CharSinkBase sink) {
        if (b >> 3 != -2 || seq.length() - index < 4) {
            return Chars.utf8error();
        }
        byte b2 = Unsafe.getUnsafe().getByte(index + 1);
        byte b3 = Unsafe.getUnsafe().getByte(index + 2);
        byte b4 = Unsafe.getUnsafe().getByte(index + 3);
        return Chars.utf8Decode4Bytes0(b, sink, b2, b3, b4);
    }

    private static int utf8Decode4Bytes0(int b, CharSinkBase sink, byte b2, byte b3, byte b4) {
        if (Chars.isMalformed4(b2, b3, b4)) {
            return Chars.utf8error();
        }
        int codePoint = b << 18 ^ b2 << 12 ^ b3 << 6 ^ b4 ^ 0x381F80;
        if (Character.isSupplementaryCodePoint(codePoint)) {
            sink.put(Character.highSurrogate(codePoint));
            sink.put(Character.lowSurrogate(codePoint));
            return 4;
        }
        return Chars.utf8error();
    }

    private static int utf8Decode4BytesZ(long lo, int b, CharSink sink) {
        if (b >> 3 != -2) {
            return Chars.utf8error();
        }
        byte b2 = Unsafe.getUnsafe().getByte(lo + 1L);
        if (b2 == 0) {
            return Chars.utf8error();
        }
        byte b3 = Unsafe.getUnsafe().getByte(lo + 2L);
        if (b3 == 0) {
            return Chars.utf8error();
        }
        byte b4 = Unsafe.getUnsafe().getByte(lo + 3L);
        if (b4 == 0) {
            return Chars.utf8error();
        }
        return Chars.utf8Decode4Bytes0(b, sink, b2, b3, b4);
    }

    private static int utf8error() {
        return -1;
    }
}

