/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.metrics;

import io.questdb.metrics.CounterWithOneLabel;
import io.questdb.metrics.PrometheusFormatUtils;
import io.questdb.std.str.CharSink;
import java.util.concurrent.atomic.LongAdder;

public class CounterWithOneLabelImpl
implements CounterWithOneLabel {
    private final LongAdder[] counters;
    private final CharSequence labelName0;
    private final CharSequence[] labelValues0;
    private final CharSequence name;

    CounterWithOneLabelImpl(CharSequence name, CharSequence labelName0, CharSequence[] labelValues0) {
        this.name = name;
        this.labelName0 = labelName0;
        this.labelValues0 = labelValues0;
        this.counters = new LongAdder[labelValues0.length];
        int n = labelValues0.length;
        for (int i = 0; i < n; ++i) {
            this.counters[i] = new LongAdder();
        }
    }

    @Override
    public void inc(short label0) {
        this.counters[label0].increment();
    }

    @Override
    public void scrapeIntoPrometheus(CharSink sink) {
        PrometheusFormatUtils.appendCounterType(this.name, sink);
        int n = this.counters.length;
        for (int i = 0; i < n; ++i) {
            PrometheusFormatUtils.appendCounterNamePrefix(this.name, sink);
            sink.put('{');
            PrometheusFormatUtils.appendLabel(sink, this.labelName0, this.labelValues0[i]);
            sink.put('}');
            PrometheusFormatUtils.appendSampleLineSuffix(sink, this.counters[i].longValue());
        }
        PrometheusFormatUtils.appendNewLine(sink);
    }
}

