/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.ops;

import io.questdb.cairo.AlterTableContextException;
import io.questdb.cairo.AttachDetachStatus;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.EntryUnavailableException;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.vm.MemoryFCRImpl;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.cairo.vm.api.MemoryCR;
import io.questdb.cairo.wal.MetadataService;
import io.questdb.griffin.engine.ops.AbstractOperation;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.LongList;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.str.DirectCharSequence;
import io.questdb.tasks.TableWriterTask;

public class AlterOperation
extends AbstractOperation
implements Mutable {
    public static final short ADD_COLUMN = 1;
    public static final short ADD_INDEX = 4;
    public static final short ADD_SYMBOL_CACHE = 6;
    public static final short ATTACH_PARTITION = 3;
    public static final String CMD_NAME = "ALTER TABLE";
    public static final short DETACH_PARTITION = 12;
    public static final short DO_NOTHING = 0;
    public static final short DROP_COLUMN = 8;
    public static final short DROP_INDEX = 5;
    public static final short DROP_PARTITION = 2;
    public static final short REMOVE_SYMBOL_CACHE = 7;
    public static final short RENAME_COLUMN = 9;
    public static final short SET_PARAM_COMMIT_LAG = 11;
    public static final short SET_PARAM_MAX_UNCOMMITTED_ROWS = 10;
    private static final Log LOG = LogFactory.getLog(AlterOperation.class);
    private final DirectCharSequenceList directExtraStrInfo = new DirectCharSequenceList();
    private final LongList extraInfo;
    private final ObjCharSequenceList extraStrInfo;
    private CharSequenceList activeExtraStrInfo;
    private short command;
    private MemoryFCRImpl deserializeMem;

    public AlterOperation() {
        this(new LongList(), new ObjList<CharSequence>());
    }

    public AlterOperation(LongList extraInfo, ObjList<CharSequence> charSequenceObjList) {
        this.extraInfo = extraInfo;
        this.extraStrInfo = new ObjCharSequenceList(charSequenceObjList);
        this.command = 0;
    }

    @Override
    public long apply(MetadataService svc, boolean contextAllowsAnyStructureChanges) throws AlterTableContextException {
        try {
            switch (this.command) {
                case 1: {
                    this.applyAddColumn(svc);
                    break;
                }
                case 8: {
                    if (!contextAllowsAnyStructureChanges) {
                        throw AlterTableContextException.INSTANCE;
                    }
                    this.applyDropColumn(svc);
                    break;
                }
                case 9: {
                    if (!contextAllowsAnyStructureChanges) {
                        throw AlterTableContextException.INSTANCE;
                    }
                    this.applyRenameColumn(svc);
                    break;
                }
                case 2: {
                    this.applyDropPartition(svc);
                    break;
                }
                case 12: {
                    this.applyDetachPartition(svc);
                    break;
                }
                case 3: {
                    this.applyAttachPartition(svc);
                    break;
                }
                case 4: {
                    this.applyAddIndex(svc);
                    break;
                }
                case 5: {
                    this.applyDropIndex(svc);
                    break;
                }
                case 6: {
                    this.applySetSymbolCache(svc, true);
                    break;
                }
                case 7: {
                    this.applySetSymbolCache(svc, false);
                    break;
                }
                case 10: {
                    this.applyParamUncommittedRows(svc);
                    break;
                }
                case 11: {
                    this.applyParamO3MaxLag(svc);
                    break;
                }
                default: {
                    LOG.error().$("invalid alter table command [code=").$(this.command).$(" ,table=").$(svc.getTableToken()).I$();
                    throw CairoException.critical(0).put("invalid alter table command [code=").put(this.command).put(']');
                }
            }
        }
        catch (EntryUnavailableException ex) {
            throw ex;
        }
        catch (CairoException e) {
            LOG.critical().$("could not alter table [table=").$(svc.getTableToken()).$(", command=").$(this.command).$(", errno=").$(e.getErrno()).$(", message=`").$(e.getFlyweightMessage()).$('`').I$();
            throw e;
        }
        return 0L;
    }

    @Override
    public void clear() {
        this.command = 0;
        this.extraStrInfo.clear();
        this.directExtraStrInfo.clear();
        this.activeExtraStrInfo = this.extraStrInfo;
        this.extraInfo.clear();
        this.clearCommandCorrelationId();
    }

    @Override
    public AlterOperation deserialize(TableWriterTask event) {
        this.clear();
        this.tableToken = event.getTableToken();
        long readPtr = event.getData();
        long length = event.getDataSize();
        long hi = readPtr + length;
        if (readPtr + 10L >= hi) {
            throw CairoException.critical(0).put("invalid alter statement serialized to writer queue [1]");
        }
        if (this.deserializeMem == null) {
            this.deserializeMem = new MemoryFCRImpl();
        }
        this.deserializeMem.of(readPtr, length);
        this.deserializeBody(this.deserializeMem, 0L, length);
        return this;
    }

    public void deserializeBody(MemoryCR buffer, long offsetLo, long offsetHi) {
        this.clear();
        long readPtr = offsetLo;
        if (readPtr + 10L > offsetHi) {
            throw CairoException.critical(0).put("cannot read alter statement serialized, data is too short to read 10 bytes header [offset=").put(offsetLo).put(", size=").put(offsetHi - offsetLo).put(']');
        }
        this.command = buffer.getShort(readPtr);
        this.tableNamePosition = buffer.getInt(readPtr += 2L);
        int longSize = buffer.getInt(readPtr += 4L);
        if (longSize < 0 || (readPtr += 4L) + (long)longSize * 8L >= offsetHi) {
            throw CairoException.critical(0).put("invalid alter statement serialized to writer queue [2]");
        }
        this.extraInfo.clear();
        for (int i = 0; i < longSize; ++i) {
            this.extraInfo.add(buffer.getLong(readPtr));
            readPtr += 8L;
        }
        this.directExtraStrInfo.of(buffer, readPtr, offsetHi);
        this.activeExtraStrInfo = this.directExtraStrInfo;
    }

    @Override
    public boolean isStructural() {
        switch (this.command) {
            case 1: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public AlterOperation of(short command, TableToken tableToken, int tableId, int tableNamePosition) {
        this.init(2, CMD_NAME, tableToken, tableId, -1L, tableNamePosition);
        this.command = command;
        this.activeExtraStrInfo = this.extraStrInfo;
        return this;
    }

    public void ofAddColumn(int tableId, TableToken tableToken, int tableNamePosition, CharSequence columnName, int columnNamePosition, int columnType, int symbolCapacity, boolean cache, boolean indexed, int indexValueBlockCapacity) {
        this.of((short)1, tableToken, tableId, tableNamePosition);
        assert (columnName != null && columnName.length() > 0);
        this.extraStrInfo.strings.add(Chars.toString(columnName));
        this.extraInfo.add(columnType);
        this.extraInfo.add(symbolCapacity);
        this.extraInfo.add(cache ? 1L : -1L);
        this.extraInfo.add(indexed ? 1L : -1L);
        this.extraInfo.add(indexValueBlockCapacity);
        this.extraInfo.add(columnNamePosition);
    }

    @Override
    public void serialize(TableWriterTask event) {
        int i;
        super.serialize(event);
        event.putShort(this.command);
        event.putInt(this.tableNamePosition);
        event.putInt(this.extraInfo.size());
        int n = this.extraInfo.size();
        for (i = 0; i < n; ++i) {
            event.putLong(this.extraInfo.getQuick(i));
        }
        event.putInt(this.extraStrInfo.size());
        n = this.extraStrInfo.size();
        for (i = 0; i < n; ++i) {
            event.putStr(this.extraStrInfo.getStrA(i));
        }
    }

    public void serializeBody(MemoryA sink) {
        int i;
        sink.putShort(this.command);
        sink.putInt(this.tableNamePosition);
        sink.putInt(this.extraInfo.size());
        int n = this.extraInfo.size();
        for (i = 0; i < n; ++i) {
            sink.putLong(this.extraInfo.getQuick(i));
        }
        sink.putInt(this.extraStrInfo.size());
        n = this.extraStrInfo.size();
        for (i = 0; i < n; ++i) {
            sink.putStr(this.extraStrInfo.getStrA(i));
        }
    }

    @Override
    public void startAsync() {
    }

    private void applyAddColumn(MetadataService svc) {
        int lParam = 0;
        int n = this.activeExtraStrInfo.size();
        for (int i = 0; i < n; ++i) {
            CharSequence columnName = this.activeExtraStrInfo.getStrA(i);
            int type = (int)this.extraInfo.get(lParam++);
            int symbolCapacity = (int)this.extraInfo.get(lParam++);
            boolean symbolCacheFlag = this.extraInfo.get(lParam++) > 0L;
            boolean isIndexed = this.extraInfo.get(lParam++) > 0L;
            int indexValueBlockCapacity = (int)this.extraInfo.get(lParam++);
            int columnNamePosition = (int)this.extraInfo.get(lParam++);
            try {
                svc.addColumn(columnName, type, symbolCapacity, symbolCacheFlag, isIndexed, indexValueBlockCapacity, false);
                continue;
            }
            catch (CairoException e) {
                e.position(columnNamePosition);
                throw e;
            }
        }
    }

    private void applyAddIndex(MetadataService svc) {
        CharSequence columnName = this.activeExtraStrInfo.getStrA(0);
        try {
            svc.addIndex(columnName, (int)this.extraInfo.get(0));
        }
        catch (CairoException e) {
            e.position(this.tableNamePosition);
            throw e;
        }
    }

    private void applyAttachPartition(MetadataService svc) {
        int n = this.extraInfo.size() / 2;
        for (int i = 0; i < n; ++i) {
            long partitionTimestamp = this.extraInfo.getQuick(i * 2);
            AttachDetachStatus attachDetachStatus = svc.attachPartition(partitionTimestamp);
            if (AttachDetachStatus.OK == attachDetachStatus) continue;
            throw CairoException.critical(-100).put("could not attach partition [table=").put(this.tableToken != null ? this.tableToken.getTableName() : "<null>").put(", detachStatus=").put(attachDetachStatus.name()).put(", partitionTimestamp=").ts(partitionTimestamp).put(", partitionBy=").put(PartitionBy.toString(svc.getPartitionBy())).put(']').position((int)this.extraInfo.getQuick(i * 2 + 1));
        }
    }

    private void applyDetachPartition(MetadataService svc) {
        int n = this.extraInfo.size() / 2;
        for (int i = 0; i < n; ++i) {
            long partitionTimestamp = this.extraInfo.getQuick(i * 2);
            AttachDetachStatus attachDetachStatus = svc.detachPartition(partitionTimestamp);
            if (AttachDetachStatus.OK == attachDetachStatus) continue;
            throw CairoException.critical(-100).put("could not detach partition [table=").put(this.tableToken != null ? this.tableToken.getTableName() : "<null>").put(", detachStatus=").put(attachDetachStatus.name()).put(", partitionTimestamp=").ts(partitionTimestamp).put(", partitionBy=").put(PartitionBy.toString(svc.getPartitionBy())).put(']').position((int)this.extraInfo.getQuick(i * 2 + 1));
        }
    }

    private void applyDropColumn(MetadataService svc) {
        int n = this.activeExtraStrInfo.size();
        for (int i = 0; i < n; ++i) {
            svc.removeColumn(this.activeExtraStrInfo.getStrA(i));
        }
    }

    private void applyDropIndex(MetadataService svc) {
        CharSequence columnName = this.activeExtraStrInfo.getStrA(0);
        int columnNamePosition = (int)this.extraInfo.get(0);
        try {
            svc.dropIndex(columnName);
        }
        catch (CairoException e) {
            e.position(columnNamePosition);
            throw e;
        }
    }

    private void applyDropPartition(MetadataService svc) {
        int n = this.extraInfo.size() / 2;
        for (int i = 0; i < n; ++i) {
            long partitionTimestamp = this.extraInfo.getQuick(i * 2);
            if (svc.removePartition(partitionTimestamp)) continue;
            throw CairoException.nonCritical().put("could not remove partition [table=").put(this.tableToken != null ? this.tableToken.getTableName() : "<null>").put(", partitionTimestamp=").ts(partitionTimestamp).put(", partitionBy=").put(PartitionBy.toString(svc.getPartitionBy())).put(']').position((int)this.extraInfo.getQuick(i * 2 + 1));
        }
    }

    private void applyParamO3MaxLag(MetadataService svc) {
        long o3MaxLag = this.extraInfo.get(0);
        try {
            svc.setMetaO3MaxLag(o3MaxLag);
        }
        catch (CairoException e) {
            LOG.error().$("could not change o3MaxLag [table=").utf8(this.tableToken != null ? this.tableToken.getTableName() : "<null>").$(", errno=").$(e.getErrno()).$(", error=").$(e.getFlyweightMessage()).I$();
            throw e;
        }
    }

    private void applyParamUncommittedRows(MetadataService svc) {
        int maxUncommittedRows = (int)this.extraInfo.get(0);
        try {
            svc.setMetaMaxUncommittedRows(maxUncommittedRows);
        }
        catch (CairoException e) {
            e.position(this.tableNamePosition);
            throw e;
        }
    }

    private void applyRenameColumn(MetadataService svc) {
        int i = 0;
        int n = this.activeExtraStrInfo.size();
        while (i < n) {
            CharSequence columnName = this.activeExtraStrInfo.getStrA(i++);
            CharSequence newName = this.activeExtraStrInfo.getStrB(i++);
            svc.renameColumn(columnName, newName);
        }
    }

    private void applySetSymbolCache(MetadataService svc, boolean isCacheOn) {
        CharSequence columnName = this.activeExtraStrInfo.getStrA(0);
        svc.changeCacheFlag(svc.getMetadata().getColumnIndex(columnName), isCacheOn);
    }

    private static class ObjCharSequenceList
    implements CharSequenceList {
        private final ObjList<CharSequence> strings;

        public ObjCharSequenceList(ObjList<CharSequence> strings) {
            this.strings = strings;
        }

        @Override
        public void clear() {
            this.strings.clear();
        }

        @Override
        public CharSequence getStrA(int i) {
            return this.strings.get(i);
        }

        @Override
        public CharSequence getStrB(int i) {
            return this.strings.get(i);
        }

        @Override
        public int size() {
            return this.strings.size();
        }
    }

    private static class DirectCharSequenceList
    implements CharSequenceList {
        private final LongList offsets = new LongList();
        private final DirectCharSequence strA = new DirectCharSequence();
        private final DirectCharSequence strB = new DirectCharSequence();

        private DirectCharSequenceList() {
        }

        @Override
        public void clear() {
            this.offsets.clear();
        }

        @Override
        public CharSequence getStrA(int i) {
            long lo = this.offsets.get(i * 2);
            long hi = this.offsets.get(i * 2 + 1);
            this.strA.of(lo, hi);
            return this.strA;
        }

        @Override
        public CharSequence getStrB(int i) {
            long lo = this.offsets.get(i * 2);
            long hi = this.offsets.get(i * 2 + 1);
            this.strB.of(lo, hi);
            return this.strB;
        }

        public void of(MemoryCR buffer, long lo, long hi) {
            if (lo + 4L > hi) {
                throw CairoException.critical(0).put("invalid alter statement serialized to writer queue [11]");
            }
            int size = buffer.getInt(lo);
            lo += 4L;
            for (int i = 0; i < size; ++i) {
                int stringSize;
                if (lo + 4L > hi) {
                    throw CairoException.critical(0).put("invalid alter statement serialized to writer queue [12]");
                }
                if ((lo += 4L) + (long)(stringSize = 2 * buffer.getInt(lo)) > hi) {
                    throw CairoException.critical(0).put("invalid alter statement serialized to writer queue [13]");
                }
                long address = buffer.addressOf(lo);
                this.offsets.add(address, address + (long)stringSize);
                lo += (long)stringSize;
            }
        }

        @Override
        public int size() {
            return this.offsets.size() / 2;
        }
    }

    static interface CharSequenceList
    extends Mutable {
        public CharSequence getStrA(int var1);

        public CharSequence getStrB(int var1);

        public int size();
    }
}

