/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordChain;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.AbstractJoinCursor;
import io.questdb.griffin.engine.join.JoinRecordMetadata;
import io.questdb.griffin.engine.join.NullRecordFactory;
import io.questdb.griffin.engine.join.OuterJoinRecord;
import io.questdb.griffin.model.JoinContext;
import io.questdb.std.Misc;
import org.jetbrains.annotations.NotNull;

public class HashOuterJoinFilteredRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final HashOuterJoinRecordCursor cursor;
    private final Function filter;
    private final JoinContext joinContext;
    private final RecordCursorFactory masterFactory;
    private final RecordSink masterSink;
    private final RecordCursorFactory slaveFactory;
    private final RecordSink slaveKeySink;

    public HashOuterJoinFilteredRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, ColumnTypes joinColumnTypes, ColumnTypes valueTypes, RecordSink masterSink, RecordSink slaveKeySink, RecordSink slaveChainSink, int columnSplit, @NotNull Function filter, JoinContext joinContext) {
        super(metadata);
        this.masterFactory = masterFactory;
        this.slaveFactory = slaveFactory;
        RecordChain slaveChain = new RecordChain(slaveFactory.getMetadata(), slaveChainSink, configuration.getSqlHashJoinValuePageSize(), configuration.getSqlHashJoinValueMaxPages());
        this.masterSink = masterSink;
        this.slaveKeySink = slaveKeySink;
        Map joinKeyMap = MapFactory.createMap(configuration, joinColumnTypes, valueTypes);
        this.cursor = new HashOuterJoinRecordCursor(columnSplit, joinKeyMap, slaveChain, NullRecordFactory.getInstance(slaveFactory.getMetadata()));
        this.filter = filter;
        this.joinContext = joinContext;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor slaveCursor = this.slaveFactory.getCursor(executionContext);
        try {
            this.cursor.of(executionContext, slaveCursor);
            return this.cursor;
        }
        catch (Throwable e) {
            Misc.free(this.cursor);
            throw e;
        }
    }

    @Override
    public boolean hasDescendingOrder() {
        return this.masterFactory.hasDescendingOrder();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Hash Outer Join");
        sink.optAttr((CharSequence)"condition", this.joinContext);
        sink.attr("filter").val(this.filter);
        sink.child(this.masterFactory);
        sink.child("Hash", this.slaveFactory);
    }

    static void buildMap(RecordCursor slaveCursor, Record record, Map joinKeyMap, RecordSink slaveKeySink, RecordChain slaveChain, SqlExecutionCircuitBreaker circuitBreaker) {
        joinKeyMap.clear();
        slaveChain.clear();
        while (slaveCursor.hasNext()) {
            circuitBreaker.statefulThrowExceptionIfTripped();
            MapKey key = joinKeyMap.withKey();
            key.put(record, slaveKeySink);
            MapValue value = key.createValue();
            if (value.isNew()) {
                long offset = slaveChain.put(record, -1L);
                value.putLong(0, offset);
                value.putLong(1, offset);
                continue;
            }
            value.putLong(1, slaveChain.put(record, value.getLong(1)));
        }
    }

    @Override
    protected void _close() {
        ((JoinRecordMetadata)this.getMetadata()).close();
        this.masterFactory.close();
        this.slaveFactory.close();
        this.cursor.close();
        this.filter.close();
    }

    private class HashOuterJoinRecordCursor
    extends AbstractJoinCursor {
        private final Map joinKeyMap;
        private final OuterJoinRecord record;
        private final RecordChain slaveChain;
        private boolean isOpen;
        private Record masterRecord;
        private boolean useSlaveCursor;

        public HashOuterJoinRecordCursor(int columnSplit, Map joinKeyMap, RecordChain slaveChain, Record nullRecord) {
            super(columnSplit);
            this.record = new OuterJoinRecord(columnSplit, nullRecord);
            this.joinKeyMap = joinKeyMap;
            this.slaveChain = slaveChain;
            this.isOpen = true;
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.isOpen = false;
                this.joinKeyMap.close();
                this.slaveChain.close();
                super.close();
            }
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            if (this.useSlaveCursor && this.slaveChain.hasNext()) {
                this.record.hasSlave(true);
                do {
                    if (!HashOuterJoinFilteredRecordCursorFactory.this.filter.getBool(this.record)) continue;
                    return true;
                } while (this.slaveChain.hasNext());
            }
            if (this.masterCursor.hasNext()) {
                MapKey key = this.joinKeyMap.withKey();
                key.put(this.masterRecord, HashOuterJoinFilteredRecordCursorFactory.this.masterSink);
                MapValue value = key.findValue();
                if (value != null) {
                    this.slaveChain.of(value.getLong(0));
                    this.useSlaveCursor = true;
                    this.record.hasSlave(true);
                    while (this.slaveChain.hasNext()) {
                        if (!HashOuterJoinFilteredRecordCursorFactory.this.filter.getBool(this.record)) continue;
                        return true;
                    }
                }
                this.useSlaveCursor = false;
                this.record.hasSlave(false);
                return true;
            }
            return false;
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public void toTop() {
            this.masterCursor.toTop();
            this.useSlaveCursor = false;
            HashOuterJoinFilteredRecordCursorFactory.this.filter.toTop();
        }

        private void buildMapOfSlaveRecords(RecordCursor slaveCursor, SqlExecutionCircuitBreaker circuitBreaker) {
            if (!this.isOpen) {
                this.isOpen = true;
                this.joinKeyMap.reopen();
                this.slaveChain.reopen();
            }
            HashOuterJoinFilteredRecordCursorFactory factory = HashOuterJoinFilteredRecordCursorFactory.this;
            HashOuterJoinFilteredRecordCursorFactory.buildMap(slaveCursor, slaveCursor.getRecord(), this.joinKeyMap, factory.slaveKeySink, this.slaveChain, circuitBreaker);
        }

        void of(SqlExecutionContext executionContext, RecordCursor slaveCursor) throws SqlException {
            this.slaveCursor = slaveCursor;
            this.buildMapOfSlaveRecords(slaveCursor, executionContext.getCircuitBreaker());
            this.masterCursor = HashOuterJoinFilteredRecordCursorFactory.this.masterFactory.getCursor(executionContext);
            this.masterRecord = this.masterCursor.getRecord();
            Record slaveRecord = this.slaveChain.getRecord();
            this.slaveChain.setSymbolTableResolver(slaveCursor);
            this.record.of(this.masterRecord, slaveRecord);
            this.useSlaveCursor = false;
        }
    }
}

