/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.EmptyTableRecordCursor;
import io.questdb.griffin.engine.join.AbstractJoinCursor;
import io.questdb.griffin.engine.join.JoinRecord;
import io.questdb.griffin.engine.join.JoinRecordMetadata;
import io.questdb.std.Misc;

public class CrossJoinRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final CrossJoinRecordCursor cursor;
    private final RecordCursorFactory masterFactory;
    private final RecordCursorFactory slaveFactory;

    public CrossJoinRecordCursorFactory(RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, int columnSplit) {
        super(metadata);
        this.masterFactory = masterFactory;
        this.slaveFactory = slaveFactory;
        this.cursor = new CrossJoinRecordCursor(columnSplit);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor masterCursor = this.masterFactory.getCursor(executionContext);
        RecordCursor slaveCursor = null;
        try {
            slaveCursor = this.slaveFactory.getCursor(executionContext);
            if (masterCursor.hasNext()) {
                this.cursor.of(masterCursor, slaveCursor);
                return this.cursor;
            }
            slaveCursor = Misc.free(slaveCursor);
            Misc.free(masterCursor);
        }
        catch (Throwable ex) {
            Misc.free(masterCursor);
            Misc.free(slaveCursor);
            throw ex;
        }
        return EmptyTableRecordCursor.INSTANCE;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public boolean supportsUpdateRowId(TableToken tableToken) {
        return this.masterFactory.supportsUpdateRowId(tableToken);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Cross Join");
        sink.child(this.masterFactory);
        sink.child(this.slaveFactory);
    }

    @Override
    protected void _close() {
        ((JoinRecordMetadata)this.getMetadata()).close();
        this.masterFactory.close();
        this.slaveFactory.close();
    }

    private static class CrossJoinRecordCursor
    extends AbstractJoinCursor {
        private final JoinRecord record;

        public CrossJoinRecordCursor(int columnSplit) {
            super(columnSplit);
            this.record = new JoinRecord(columnSplit);
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            if (this.slaveCursor.hasNext()) {
                return true;
            }
            if (this.masterCursor.hasNext()) {
                this.slaveCursor.toTop();
                return this.slaveCursor.hasNext();
            }
            return false;
        }

        @Override
        public long size() {
            long sizeA = this.masterCursor.size();
            long sizeB = this.slaveCursor.size();
            if (sizeA == -1L || sizeB == -1L) {
                return -1L;
            }
            long result = sizeA * sizeB;
            return result < sizeA ? Long.MAX_VALUE : result;
        }

        @Override
        public void toTop() {
            this.masterCursor.toTop();
            this.masterCursor.hasNext();
            this.slaveCursor.toTop();
        }

        void of(RecordCursor masterCursor, RecordCursor slaveCursor) {
            this.masterCursor = masterCursor;
            this.slaveCursor = slaveCursor;
            this.record.of(masterCursor.getRecord(), slaveCursor.getRecord());
        }
    }
}

