/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.std.Misc;

public abstract class AbstractJoinCursor
implements NoRandomAccessRecordCursor {
    protected final int columnSplit;
    protected RecordCursor masterCursor;
    protected RecordCursor slaveCursor;

    public AbstractJoinCursor(int columnSplit) {
        this.columnSplit = columnSplit;
    }

    @Override
    public void close() {
        this.masterCursor = Misc.free(this.masterCursor);
        this.slaveCursor = Misc.free(this.slaveCursor);
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        if (columnIndex < this.columnSplit) {
            return this.masterCursor.getSymbolTable(columnIndex);
        }
        return this.slaveCursor.getSymbolTable(columnIndex - this.columnSplit);
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        if (columnIndex < this.columnSplit) {
            return this.masterCursor.newSymbolTable(columnIndex);
        }
        return this.slaveCursor.newSymbolTable(columnIndex - this.columnSplit);
    }
}

