/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.std.Rnd;
import org.jetbrains.annotations.NotNull;

public class SharedRandom {
    public static final ThreadLocal<Rnd> ASYNC_RANDOM = new ThreadLocal();
    public static final ThreadLocal<Rnd> RANDOM = new ThreadLocal();

    public static Rnd getAsyncRandom(CairoConfiguration configuration) {
        return SharedRandom.getRnd(configuration, ASYNC_RANDOM);
    }

    public static Rnd getRandom(CairoConfiguration configuration) {
        return SharedRandom.getRnd(configuration, RANDOM);
    }

    @NotNull
    private static Rnd getRnd(CairoConfiguration configuration, ThreadLocal<Rnd> tlRnd) {
        Rnd rnd = tlRnd.get();
        if (rnd == null) {
            rnd = new Rnd(configuration.getNanosecondClock().getTicks(), configuration.getMicrosecondClock().getTicks());
            tlRnd.set(rnd);
        }
        return rnd;
    }
}

