/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class BitwiseOrIntFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "|(II)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new BitOrIntFunction(args.getQuick(0), args.getQuick(1));
    }

    public static final class BitOrIntFunction
    extends IntFunction
    implements BinaryFunction {
        private final Function left;
        private final Function right;

        public BitOrIntFunction(Function left, Function right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public int getInt(Record rec) {
            int l = this.left.getInt(rec);
            int r = this.right.getInt(rec);
            return l != Integer.MIN_VALUE && r != Integer.MIN_VALUE ? l | r : Integer.MIN_VALUE;
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.right;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.left).val('|').val(this.right);
        }
    }
}

