/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;

public class ToTimestampFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "to_timestamp(S)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function arg = args.getQuick(0);
        return new ToTimestampFunction(arg);
    }

    public static final class ToTimestampFunction
    extends TimestampFunction
    implements UnaryFunction {
        private final Function arg;

        public ToTimestampFunction(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public String getName() {
            return "to_timestamp";
        }

        @Override
        public long getTimestamp(Record rec) {
            CharSequence value = this.arg.getStr(rec);
            try {
                return Numbers.parseLong(value);
            }
            catch (NumericException numericException) {
                return Long.MIN_VALUE;
            }
        }
    }
}

