/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.datetime.TimeZoneRules;

class OffsetTimestampFunctionFromRules
extends TimestampFunction
implements UnaryFunction {
    private final int multiplier;
    private final TimeZoneRules rules;
    private final Function timestamp;

    public OffsetTimestampFunctionFromRules(Function timestamp, TimeZoneRules rules, int multiplier) {
        this.timestamp = timestamp;
        this.rules = rules;
        this.multiplier = multiplier;
    }

    @Override
    public Function getArg() {
        return this.timestamp;
    }

    @Override
    public long getTimestamp(Record rec) {
        long utc = this.timestamp.getTimestamp(rec);
        return utc + (long)this.multiplier * this.rules.getOffset(utc);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val("to_utc(").val(this.timestamp).val(',').val(this.multiplier).val(')');
    }
}

