/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.udp;

import io.questdb.cairo.CairoEngine;
import io.questdb.cutlass.line.udp.AbstractLineProtoUdpReceiver;
import io.questdb.cutlass.line.udp.LineUdpReceiverConfiguration;
import io.questdb.mp.WorkerPool;
import io.questdb.network.Net;

public class LinuxMMLineUdpReceiver
extends AbstractLineProtoUdpReceiver {
    private final int msgCount;
    private long msgVec;

    public LinuxMMLineUdpReceiver(LineUdpReceiverConfiguration configuration, CairoEngine engine, WorkerPool workerPool) {
        super(configuration, engine, workerPool);
        this.msgCount = configuration.getMsgCount();
        this.msgVec = this.nf.msgHeaders(configuration.getMsgBufferSize(), this.msgCount);
        this.start();
    }

    @Override
    public void close() {
        super.close();
        if (this.msgVec != 0L) {
            this.nf.freeMsgHeaders(this.msgVec);
            this.msgVec = 0L;
        }
    }

    @Override
    protected boolean runSerially() {
        int count;
        boolean ran = false;
        while ((count = this.nf.recvmmsg(this.fd, this.msgVec, this.msgCount)) > 0) {
            long p = this.msgVec;
            for (int i = 0; i < count; ++i) {
                long buf = this.nf.getMMsgBuf(p);
                this.lexer.parse(buf, buf + this.nf.getMMsgBufLen(p));
                this.lexer.parseLast();
                p += Net.MMSGHDR_SIZE;
            }
            this.totalCount += (long)count;
            if (this.totalCount > (long)this.commitRate) {
                this.totalCount = 0L;
                this.parser.commitAll(this.commitMode);
            }
            if (ran) continue;
            ran = true;
        }
        this.parser.commitAll(this.commitMode);
        return ran;
    }
}

