/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.cutlass.http.HttpException;
import io.questdb.cutlass.http.HttpHeaderParser;
import io.questdb.cutlass.http.HttpMultipartContentListener;
import io.questdb.cutlass.http.ex.NotEnoughLinesException;
import io.questdb.cutlass.http.ex.RetryOperationException;
import io.questdb.cutlass.http.ex.TooFewBytesReceivedException;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.network.ServerDisconnectException;
import io.questdb.std.Mutable;
import io.questdb.std.Unsafe;
import io.questdb.std.str.DirectByteCharSequence;
import java.io.Closeable;

public class HttpMultipartContentParser
implements Closeable,
Mutable {
    private static final int BODY = 6;
    private static final int BODY_BROKEN = 8;
    private static final int BOUNDARY_INCOMPLETE = 3;
    private static final int BOUNDARY_MATCH = 1;
    private static final int BOUNDARY_NO_MATCH = 2;
    private static final int DONE = 13;
    private static final int HEADERS = 4;
    private static final int PARTIAL_HEADERS = 5;
    private static final int PARTIAL_START_BOUNDARY = 3;
    private static final int POTENTIAL_BOUNDARY = 9;
    private static final int PRE_HEADERS = 10;
    private static final int START_BOUNDARY = 2;
    private static final int START_HEADERS = 12;
    private static final int START_PARSING = 1;
    private static final int START_PRE_HEADERS = 11;
    private final HttpHeaderParser headerParser;
    private DirectByteCharSequence boundary;
    private byte boundaryByte;
    private int boundaryLen;
    private int boundaryPtr;
    private int consumedBoundaryLen;
    private long resumePtr;
    private int state;

    public HttpMultipartContentParser(HttpHeaderParser headerParser) {
        this.headerParser = headerParser;
        this.clear();
    }

    @Override
    public final void clear() {
        this.state = 1;
        this.boundaryPtr = 0;
        this.boundaryByte = 0;
        this.boundary = null;
        this.consumedBoundaryLen = 0;
        this.headerParser.clear();
    }

    @Override
    public void close() {
        this.headerParser.close();
    }

    public long getResumePtr() {
        return this.resumePtr;
    }

    public void of(DirectByteCharSequence boundary) {
        this.boundary = boundary;
        this.boundaryLen = boundary.length();
        this.boundaryByte = (byte)boundary.charAt(0);
    }

    public boolean parse(long lo, long hi, HttpMultipartContentListener listener) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        long _lo = lo;
        long ptr = lo;
        block35: while (ptr < hi) {
            switch (this.state) {
                case 8: {
                    _lo = ptr;
                    this.state = 6;
                    continue block35;
                }
                case 1: {
                    this.state = 2;
                }
                case 2: {
                    this.boundaryPtr = 2;
                }
                case 3: {
                    switch (this.matchBoundary(ptr, hi)) {
                        case 3: {
                            this.state = 3;
                            return false;
                        }
                        case 1: {
                            this.state = 11;
                            ptr += (long)this.consumedBoundaryLen;
                            continue block35;
                        }
                    }
                    throw HttpException.instance("Malformed start boundary");
                }
                case 10: {
                    switch (Unsafe.getUnsafe().getByte(ptr)) {
                        case 10: {
                            this.state = 4;
                        }
                        case 13: {
                            ++ptr;
                            continue block35;
                        }
                        case 45: {
                            listener.onPartEnd();
                            this.state = 13;
                            return true;
                        }
                    }
                    listener.onChunk(this.boundary.getLo(), this.boundary.getHi());
                    _lo = ptr;
                    this.state = 6;
                    continue block35;
                }
                case 11: {
                    switch (Unsafe.getUnsafe().getByte(ptr)) {
                        case 10: {
                            this.state = 12;
                        }
                        case 13: {
                            ++ptr;
                            continue block35;
                        }
                        case 45: {
                            return true;
                        }
                    }
                    throw HttpException.instance("Malformed start boundary");
                }
                case 4: {
                    listener.onPartEnd();
                    this.state = 4;
                }
                case 12: {
                    this.headerParser.clear();
                    this.state = 12;
                }
                case 5: {
                    ptr = this.headerParser.parse(ptr, hi, false);
                    if (this.headerParser.isIncomplete()) {
                        this.state = 5;
                        return false;
                    }
                    _lo = ptr;
                    listener.onPartBegin(this.headerParser);
                    this.state = 6;
                    continue block35;
                }
                case 6: {
                    byte b = Unsafe.getUnsafe().getByte(ptr++);
                    if (b != this.boundaryByte) continue block35;
                    this.boundaryPtr = 1;
                    switch (this.matchBoundary(ptr, hi)) {
                        case 3: {
                            this.onChunkWithRetryHandle(listener, _lo, ptr - 1L, 9, hi, true);
                            return false;
                        }
                        case 1: {
                            ptr = this.onChunkWithRetryHandle(listener, _lo, ptr - 1L, 10, ptr + (long)this.consumedBoundaryLen, false);
                            continue block35;
                        }
                    }
                    continue block35;
                }
                case 9: {
                    int p = this.boundaryPtr;
                    switch (this.matchBoundary(ptr, hi)) {
                        case 3: {
                            return false;
                        }
                        case 1: {
                            ptr += (long)this.consumedBoundaryLen;
                            this.state = 10;
                            continue block35;
                        }
                    }
                    this.onChunkWithRetryHandle(listener, this.boundary.getLo(), this.boundary.getLo() + (long)p, 8, ptr, true);
                    continue block35;
                }
            }
            return true;
        }
        if (this.state == 6) {
            this.onChunkWithRetryHandle(listener, _lo, ptr, 8, ptr, true);
        }
        return false;
    }

    private int matchBoundary(long lo, long hi) {
        long start = lo;
        int ptr = this.boundaryPtr;
        while (lo < hi && ptr < this.boundaryLen) {
            if (Unsafe.getUnsafe().getByte(lo++) == this.boundary.byteAt(ptr++)) continue;
            return 2;
        }
        this.boundaryPtr = ptr;
        if (this.boundaryPtr < this.boundaryLen) {
            return 3;
        }
        this.consumedBoundaryLen = (int)(lo - start);
        return 1;
    }

    private long onChunkWithRetryHandle(HttpMultipartContentListener listener, long lo, long hi, int state, long resumePtr, boolean handleIncomplete) throws PeerIsSlowToReadException, PeerDisconnectedException, ServerDisconnectException {
        RetryOperationException needsRetry = null;
        try {
            listener.onChunk(lo, hi);
        }
        catch (RetryOperationException e) {
            needsRetry = e;
        }
        catch (NotEnoughLinesException e) {
            if (handleIncomplete) {
                this.resumePtr = lo;
                throw TooFewBytesReceivedException.INSTANCE;
            }
            throw e;
        }
        this.state = state;
        this.resumePtr = resumePtr;
        if (needsRetry != null) {
            throw needsRetry;
        }
        return resumePtr;
    }
}

