/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.pool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.pool.AbstractMultiTenantPool;
import io.questdb.cairo.pool.PoolTenant;
import io.questdb.cairo.wal.WalWriter;
import io.questdb.cairo.wal.seq.TableSequencerAPI;

public class WalWriterPool
extends AbstractMultiTenantPool<WalWriterTenant> {
    private final CairoEngine engine;

    public WalWriterPool(CairoConfiguration configuration, CairoEngine engine) {
        super(configuration);
        this.engine = engine;
    }

    @Override
    protected byte getListenerSrc() {
        return 1;
    }

    @Override
    protected WalWriterTenant newTenant(TableToken tableToken, AbstractMultiTenantPool.Entry<WalWriterTenant> entry, int index) {
        return new WalWriterTenant(this, entry, index, tableToken, this.engine.getTableSequencerAPI());
    }

    public static class WalWriterTenant
    extends WalWriter
    implements PoolTenant {
        private final int index;
        private AbstractMultiTenantPool.Entry<WalWriterTenant> entry;
        private AbstractMultiTenantPool<WalWriterTenant> pool;

        public WalWriterTenant(AbstractMultiTenantPool<WalWriterTenant> pool, AbstractMultiTenantPool.Entry<WalWriterTenant> entry, int index, TableToken tableToken, TableSequencerAPI tableSequencerAPI) {
            super(pool.getConfiguration(), tableToken, tableSequencerAPI);
            this.pool = pool;
            this.entry = entry;
            this.index = index;
        }

        @Override
        public void close() {
            if (this.isOpen()) {
                AbstractMultiTenantPool<WalWriterTenant> pool = this.pool;
                if (pool != null && this.entry != null) {
                    if (!this.isDistressed()) {
                        if (pool.returnToPool(this)) {
                            return;
                        }
                    } else {
                        super.close();
                        pool.expelFromPool(this);
                        return;
                    }
                }
                super.close();
            }
        }

        public AbstractMultiTenantPool.Entry<WalWriterTenant> getEntry() {
            return this.entry;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public void goodbye() {
            this.entry = null;
            this.pool = null;
        }

        @Override
        public void refresh() {
            try {
                this.goActive();
            }
            catch (Throwable ex) {
                this.close();
                throw ex;
            }
        }
    }
}

