/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.map.FastMapRecord;
import io.questdb.cairo.map.MapValue;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.Long256Util;
import io.questdb.std.Unsafe;

final class FastMapValue
implements MapValue {
    private final Long256Impl long256 = new Long256Impl();
    private final int[] valueOffsets;
    private long address;
    private long limit;
    private boolean newValue;
    private FastMapRecord record;

    public FastMapValue(int[] valueOffsets) {
        this.valueOffsets = valueOffsets;
    }

    @Override
    public void addByte(int index, byte value) {
        long p = this.address0(index);
        Unsafe.getUnsafe().putByte(p, (byte)(Unsafe.getUnsafe().getByte(p) + value));
    }

    @Override
    public void addDouble(int index, double value) {
        long p = this.address0(index);
        Unsafe.getUnsafe().putDouble(p, Unsafe.getUnsafe().getDouble(p) + value);
    }

    @Override
    public void addFloat(int index, float value) {
        long p = this.address0(index);
        Unsafe.getUnsafe().putFloat(p, Unsafe.getUnsafe().getFloat(p) + value);
    }

    @Override
    public void addInt(int index, int value) {
        long p = this.address0(index);
        Unsafe.getUnsafe().putInt(p, Unsafe.getUnsafe().getInt(p) + value);
    }

    @Override
    public void addLong(int index, long value) {
        long p = this.address0(index);
        Unsafe.getUnsafe().putLong(p, Unsafe.getUnsafe().getLong(p) + value);
    }

    @Override
    public void addLong256(int index, Long256 value) {
        Long256 acc = this.getLong256A(index);
        Long256Util.add(acc, value);
        long p = this.address0(index);
        Unsafe.getUnsafe().putLong(p, acc.getLong0());
        Unsafe.getUnsafe().putLong(p + 8L, acc.getLong1());
        Unsafe.getUnsafe().putLong(p + 16L, acc.getLong2());
        Unsafe.getUnsafe().putLong(p + 24L, acc.getLong3());
    }

    @Override
    public void addShort(int index, short value) {
        long p = this.address0(index);
        Unsafe.getUnsafe().putShort(p, (short)(Unsafe.getUnsafe().getShort(p) + value));
    }

    @Override
    public long getAddress() {
        return this.address;
    }

    @Override
    public boolean getBool(int index) {
        return this.getByte(index) == 1;
    }

    @Override
    public byte getByte(int index) {
        return Unsafe.getUnsafe().getByte(this.address0(index));
    }

    @Override
    public char getChar(int index) {
        return Unsafe.getUnsafe().getChar(this.address0(index));
    }

    @Override
    public long getDate(int index) {
        return this.getLong(index);
    }

    @Override
    public double getDouble(int index) {
        return Unsafe.getUnsafe().getDouble(this.address0(index));
    }

    @Override
    public float getFloat(int index) {
        return Unsafe.getUnsafe().getFloat(this.address0(index));
    }

    @Override
    public byte getGeoByte(int col) {
        return this.getByte(col);
    }

    @Override
    public int getGeoInt(int col) {
        return this.getInt(col);
    }

    @Override
    public long getGeoLong(int col) {
        return this.getLong(col);
    }

    @Override
    public short getGeoShort(int col) {
        return this.getShort(col);
    }

    @Override
    public int getInt(int index) {
        return Unsafe.getUnsafe().getInt(this.address0(index));
    }

    @Override
    public long getLong(int index) {
        return Unsafe.getUnsafe().getLong(this.address0(index));
    }

    @Override
    public Long256 getLong256A(int index) {
        long p = this.address0(index);
        this.long256.setAll(Unsafe.getUnsafe().getLong(p), Unsafe.getUnsafe().getLong(p + 8L), Unsafe.getUnsafe().getLong(p + 16L), Unsafe.getUnsafe().getLong(p + 24L));
        return this.long256;
    }

    @Override
    public long getLong128Hi(int col) {
        return Unsafe.getUnsafe().getLong(this.address0(col) + 8L);
    }

    @Override
    public long getLong128Lo(int col) {
        return Unsafe.getUnsafe().getLong(this.address0(col));
    }

    @Override
    public short getShort(int index) {
        return Unsafe.getUnsafe().getShort(this.address0(index));
    }

    @Override
    public long getTimestamp(int index) {
        return this.getLong(index);
    }

    @Override
    public boolean isNew() {
        return this.newValue;
    }

    @Override
    public void putBool(int index, boolean value) {
        this.putByte(index, (byte)(value ? 1 : 0));
    }

    @Override
    public void putByte(int index, byte value) {
        long p = this.address0(index);
        assert (p + 1L < this.limit);
        Unsafe.getUnsafe().putByte(p, value);
    }

    @Override
    public void putChar(int index, char value) {
        long p = this.address0(index);
        assert (p + 2L < this.limit);
        Unsafe.getUnsafe().putChar(p, value);
    }

    @Override
    public void putDate(int index, long value) {
        this.putLong(index, value);
    }

    @Override
    public void putDouble(int index, double value) {
        long p = this.address0(index);
        assert (p + 8L < this.limit);
        Unsafe.getUnsafe().putDouble(p, value);
    }

    @Override
    public void putFloat(int index, float value) {
        long p = this.address0(index);
        assert (p + 4L < this.limit);
        Unsafe.getUnsafe().putFloat(p, value);
    }

    @Override
    public void putInt(int index, int value) {
        long p = this.address0(index);
        assert (p + 4L < this.limit);
        Unsafe.getUnsafe().putInt(p, value);
    }

    @Override
    public void putLong(int index, long value) {
        long p = this.address0(index);
        assert (p + 8L < this.limit);
        Unsafe.getUnsafe().putLong(p, value);
    }

    @Override
    public void putLong128(int index, long lo, long hi) {
        long address = this.address0(index);
        Unsafe.getUnsafe().putLong(address, lo);
        Unsafe.getUnsafe().putLong(address + 8L, hi);
    }

    @Override
    public void putLong256(int index, Long256 value) {
        long p = this.address0(index);
        assert (p + 32L < this.limit);
        Unsafe.getUnsafe().putLong(p, value.getLong0());
        Unsafe.getUnsafe().putLong(p + 8L, value.getLong1());
        Unsafe.getUnsafe().putLong(p + 16L, value.getLong2());
        Unsafe.getUnsafe().putLong(p + 24L, value.getLong3());
    }

    @Override
    public void putShort(int index, short value) {
        Unsafe.getUnsafe().putShort(this.address0(index), value);
    }

    @Override
    public void putTimestamp(int index, long value) {
        this.putLong(index, value);
    }

    @Override
    public void setMapRecordHere() {
        this.record.of(this.address, this.limit);
    }

    private long address0(int index) {
        return this.address + (long)this.valueOffsets[index];
    }

    void linkRecord(FastMapRecord record) {
        this.record = record;
    }

    FastMapValue of(long address, long limit, boolean newValue) {
        this.address = address;
        this.limit = limit;
        this.newValue = newValue;
        return this;
    }
}

