/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AbstractRecordMetadata;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.ColumnMetadataCollection;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.TableRecordMetadata;

public class GenericRecordMetadata
extends AbstractRecordMetadata {
    public static void copyColumns(RecordMetadata from, GenericRecordMetadata to) {
        if (from instanceof AbstractRecordMetadata) {
            AbstractRecordMetadata gm = (AbstractRecordMetadata)from;
            int n = gm.getColumnCount();
            for (int i = 0; i < n; ++i) {
                to.add(gm.getColumnMetadata(i));
            }
        } else {
            int n = from.getColumnCount();
            for (int i = 0; i < n; ++i) {
                to.add(new TableColumnMetadata(from.getColumnName(i), from.getColumnType(i), from.isColumnIndexed(i), from.getIndexValueBlockCapacity(i), from.isSymbolTableStatic(i), GenericRecordMetadata.copyOf(from.getMetadata(i))));
            }
        }
    }

    public static GenericRecordMetadata copyDense(TableRecordMetadata tableMetadata) {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        int columnCount = tableMetadata.getColumnCount();
        int timestampIndex = tableMetadata.getTimestampIndex();
        if (tableMetadata instanceof ColumnMetadataCollection) {
            for (int i = 0; i < columnCount; ++i) {
                TableColumnMetadata column = ((ColumnMetadataCollection)((Object)tableMetadata)).getColumnMetadata(i);
                if (column.isDeleted()) continue;
                metadata.add(column);
                if (i != timestampIndex) continue;
                metadata.setTimestampIndex(metadata.getColumnCount() - 1);
            }
        } else {
            for (int i = 0; i < columnCount; ++i) {
                int columnType = metadata.getColumnType(i);
                if (columnType < 0) continue;
                metadata.add(new TableColumnMetadata(metadata.getColumnName(i), columnType, metadata.isColumnIndexed(i), metadata.getIndexValueBlockCapacity(i), metadata.isSymbolTableStatic(i), metadata.getMetadata(i), metadata.getWriterIndex(i)));
                if (i != timestampIndex) continue;
                metadata.setTimestampIndex(metadata.getColumnCount() - 1);
            }
        }
        return metadata;
    }

    public static GenericRecordMetadata copyOf(RecordMetadata that) {
        if (that != null) {
            if (that instanceof GenericRecordMetadata) {
                return (GenericRecordMetadata)that;
            }
            GenericRecordMetadata metadata = GenericRecordMetadata.copyOfSansTimestamp(that);
            metadata.setTimestampIndex(that.getTimestampIndex());
            return metadata;
        }
        return null;
    }

    public static GenericRecordMetadata copyOfSansTimestamp(RecordMetadata that) {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        GenericRecordMetadata.copyColumns(that, metadata);
        return metadata;
    }

    public static GenericRecordMetadata deepCopyOf(RecordMetadata that) {
        if (that != null) {
            GenericRecordMetadata metadata = new GenericRecordMetadata();
            int n = that.getColumnCount();
            for (int i = 0; i < n; ++i) {
                metadata.add(new TableColumnMetadata(that.getColumnName(i), that.getColumnType(i), that.isColumnIndexed(i), that.getIndexValueBlockCapacity(i), that.isSymbolTableStatic(i), that.getMetadata(i), that.getWriterIndex(i)));
            }
            metadata.setTimestampIndex(that.getTimestampIndex());
            return metadata;
        }
        return null;
    }

    public static RecordMetadata removeTimestamp(RecordMetadata that) {
        if (that.getTimestampIndex() != -1) {
            if (that instanceof GenericRecordMetadata) {
                ((GenericRecordMetadata)that).setTimestampIndex(-1);
                return that;
            }
            return GenericRecordMetadata.copyOfSansTimestamp(that);
        }
        return that;
    }

    public GenericRecordMetadata add(TableColumnMetadata meta) {
        return this.add(this.columnCount, meta);
    }

    public GenericRecordMetadata add(int i, TableColumnMetadata meta) {
        int index = this.columnNameIndexMap.keyIndex(meta.getName());
        if (index > -1) {
            this.columnNameIndexMap.putAt(index, meta.getName(), i);
            this.columnMetadata.extendAndSet(i, meta);
            ++this.columnCount;
            return this;
        }
        throw CairoException.duplicateColumn(meta.getName());
    }

    @Override
    public int getColumnIndexQuiet(CharSequence columnName, int lo, int hi) {
        int index = this.columnNameIndexMap.keyIndex(columnName, lo, hi);
        if (index < 0) {
            return this.columnNameIndexMap.valueAt(index);
        }
        return -1;
    }

    public void setTimestampIndex(int index) {
        this.timestampIndex = index;
    }
}

