/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableReaderMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TxReader;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Misc;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class DynamicTableReaderMetadata
extends TableReaderMetadata
implements Closeable {
    private static final Log LOG = LogFactory.getLog(DynamicTableReaderMetadata.class);
    private final MillisecondClock clock;
    private final CairoConfiguration configuration;
    private long rowCount;
    private TxReader txFile;
    private long txn = 0L;

    public DynamicTableReaderMetadata(CairoConfiguration configuration, TableToken tableToken) {
        super(configuration, tableToken);
        this.configuration = configuration;
        this.clock = configuration.getMillisecondClock();
        try (Path path = new Path();){
            path.of(configuration.getRoot()).concat(tableToken);
            this.txFile = new TxReader(configuration.getFilesFacade()).ofRO(path.concat("_txn").$(), this.getPartitionBy());
            this.load();
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    @Override
    public void close() {
        this.txFile = Misc.free(this.txFile);
        super.close();
    }

    public long getMaxTimestamp() {
        return this.txFile.getMaxTimestamp();
    }

    public long getMinTimestamp() {
        return this.txFile.getMinTimestamp();
    }

    public long getTransientRowCount() {
        return this.txFile.getTransientRowCount();
    }

    public long getTxn() {
        return this.txn;
    }

    public long getVersion() {
        return this.txFile.getStructureVersion();
    }

    public void reload() {
        if (this.acquireTxn()) {
            return;
        }
        this.reloadSlow();
    }

    public long size() {
        return this.rowCount;
    }

    private boolean acquireTxn() {
        if (this.txn == this.txFile.getTxn()) {
            Unsafe.getUnsafe().loadFence();
            return this.txFile.getVersion() == this.txFile.unsafeReadVersion();
        }
        return false;
    }

    private void readTxnSlow(long deadline) {
        long txn;
        int count = 0;
        while (true) {
            if (this.txFile.unsafeLoadAll()) {
                this.txn = txn = this.txFile.getTxn();
                if (this.acquireTxn()) break;
            }
            ++count;
            if (this.clock.getTicks() > deadline) {
                LOG.error().$("tx read timeout [timeout=").$(this.configuration.getSpinLockTimeout()).utf8("ms]").$();
                throw CairoException.critical(0).put("Transaction read timeout");
            }
            Os.pause();
        }
        this.rowCount = this.txFile.getFixedRowCount() + this.txFile.getTransientRowCount();
        LOG.debug().$("new transaction [txn=").$(txn).$(", transientRowCount=").$(this.txFile.getTransientRowCount()).$(", fixedRowCount=").$(this.txFile.getFixedRowCount()).$(", maxTimestamp=").$ts(this.txFile.getMaxTimestamp()).$(", attempts=").$(count).$(", thread=").$(Thread.currentThread().getName()).$(']').$();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reloadMetadata(long txnStructureVersion, long deadline) {
        long pTransitionIndex;
        if (txnStructureVersion == this.getStructureVersion()) {
            return true;
        }
        while (true) {
            try {
                pTransitionIndex = this.createTransitionIndex(txnStructureVersion);
                if (pTransitionIndex < 0L) {
                    if (this.clock.getTicks() < deadline) {
                        return false;
                    }
                    LOG.error().$("metadata read timeout [timeout=").$(this.configuration.getSpinLockTimeout()).utf8("ms]").$();
                    throw CairoException.critical(0).put("Metadata read timeout");
                }
            }
            catch (CairoException ex) {
                TableUtils.handleMetadataLoadException(this.getTableToken().getTableName(), deadline, ex, this.configuration.getMillisecondClock(), this.configuration.getSpinLockTimeout());
                continue;
            }
            break;
        }
        try {
            this.applyTransitionIndex();
            boolean bl = true;
            return bl;
        }
        finally {
            TableUtils.freeTransitionIndex(pTransitionIndex);
        }
    }

    private void reloadSlow() {
        long deadline = this.clock.getTicks() + this.configuration.getSpinLockTimeout();
        do {
            this.readTxnSlow(deadline);
        } while (!this.reloadMetadata(this.txFile.getStructureVersion(), deadline));
    }
}

