/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.crypto;

import java.io.InputStream;
import java.io.OutputStream;
import jetbrains.exodus.InvalidSettingException;
import jetbrains.exodus.crypto.ExodusCryptoException;
import jetbrains.exodus.crypto.StreamCipher;
import jetbrains.exodus.crypto.StreamCipherInputStream;
import jetbrains.exodus.crypto.StreamCipherOutputStream;
import jetbrains.exodus.crypto.StreamCipherProvider;
import jetbrains.exodus.util.HexUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003\u001a\u0014\u0010\n\u001a\u00020\u000b*\u00020\u00012\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u001b\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012H\u0086\u0004\u001a\u0015\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0001H\u0086\u0004\u001a\u001a\u0010\u0017\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a\u00a8\u0006\u001b"}, d2={"newCipher", "Ljetbrains/exodus/crypto/StreamCipher;", "cipherId", "", "newCipherProvider", "Ljetbrains/exodus/crypto/StreamCipherProvider;", "Lorg/jetbrains/annotations/Nullable;", "toBinaryKey", "", "cipherKey", "cryptAsInt", "", "b", "", "decryptBy", "Ljetbrains/exodus/crypto/StreamCipherInputStream;", "Ljava/io/InputStream;", "cipherGetter", "Lkotlin/Function0;", "encryptBy", "Ljetbrains/exodus/crypto/StreamCipherOutputStream;", "Ljava/io/OutputStream;", "cipher", "with", "key", "iv", "", "xodus-openAPI"})
public final class KryptKt {
    @NotNull
    public static final StreamCipherProvider newCipherProvider(@NotNull String cipherId) {
        Intrinsics.checkNotNullParameter((Object)cipherId, (String)"cipherId");
        StreamCipherProvider streamCipherProvider = StreamCipherProvider.getProvider(cipherId);
        if (streamCipherProvider == null) {
            throw new ExodusCryptoException(Intrinsics.stringPlus((String)"Failed to load StreamCipherProvider with id = ", (Object)cipherId));
        }
        return streamCipherProvider;
    }

    @NotNull
    public static final StreamCipher newCipher(@NotNull String cipherId) {
        Intrinsics.checkNotNullParameter((Object)cipherId, (String)"cipherId");
        StreamCipher streamCipher = KryptKt.newCipherProvider(cipherId).newCipher();
        Intrinsics.checkNotNullExpressionValue((Object)streamCipher, (String)"newCipherProvider(cipherId).newCipher()");
        return streamCipher;
    }

    @NotNull
    public static final StreamCipher with(@NotNull StreamCipher $this$with, @NotNull byte[] key, long iv) {
        StreamCipher streamCipher;
        Intrinsics.checkNotNullParameter((Object)$this$with, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        StreamCipher $this$with_u24lambda_u2d0 = streamCipher = $this$with;
        boolean bl = false;
        $this$with_u24lambda_u2d0.init(key, iv);
        return streamCipher;
    }

    @NotNull
    public static final byte[] toBinaryKey(@NotNull String cipherKey) {
        Intrinsics.checkNotNullParameter((Object)cipherKey, (String)"cipherKey");
        if ((cipherKey.length() & 1) == 1) {
            throw new InvalidSettingException("Odd length of hex representation of cipher key");
        }
        byte[] byArray = HexUtil.stringToByteArray((String)cipherKey);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"stringToByteArray(cipherKey)");
        return byArray;
    }

    @NotNull
    public static final StreamCipherOutputStream encryptBy(@NotNull OutputStream $this$encryptBy, @NotNull StreamCipher cipher) {
        Intrinsics.checkNotNullParameter((Object)$this$encryptBy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cipher, (String)"cipher");
        return new StreamCipherOutputStream($this$encryptBy, cipher);
    }

    @NotNull
    public static final StreamCipherInputStream decryptBy(@NotNull InputStream $this$decryptBy, @NotNull Function0<? extends StreamCipher> cipherGetter) {
        Intrinsics.checkNotNullParameter((Object)$this$decryptBy, (String)"<this>");
        Intrinsics.checkNotNullParameter(cipherGetter, (String)"cipherGetter");
        return new StreamCipherInputStream($this$decryptBy, cipherGetter);
    }

    public static final int cryptAsInt(@NotNull StreamCipher $this$cryptAsInt, byte b2) {
        Intrinsics.checkNotNullParameter((Object)$this$cryptAsInt, (String)"<this>");
        return $this$cryptAsInt.crypt(b2) & 0xFF;
    }
}

