/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.bindings;

import java.io.ByteArrayInputStream;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.BindingUtils;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.util.LightOutputStream;
import org.jetbrains.annotations.NotNull;

public class SignedDoubleBinding
extends ComparableBinding {
    public static final SignedDoubleBinding BINDING = new SignedDoubleBinding();

    private SignedDoubleBinding() {
    }

    @Override
    public Double readObject(@NotNull ByteArrayInputStream stream) {
        return BindingUtils.readSignedDouble(stream);
    }

    @Override
    public void writeObject(@NotNull LightOutputStream output, @NotNull Comparable object) {
        long longValue;
        output.writeUnsignedLong(longValue ^ ((longValue = Double.doubleToLongBits((Double)object)) < 0L ? -1L : Long.MIN_VALUE));
    }

    public static double entryToDouble(@NotNull ByteIterable entry) {
        return (Double)BINDING.entryToObject(entry);
    }

    public static ArrayByteIterable doubleToEntry(double object) {
        return BINDING.objectToEntry(Double.valueOf(object));
    }
}

