/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate.cached;

import java.util.Arrays;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.CachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.cached.iterator.EntityIdArrayIteratorNullTypeId;
import jetbrains.exodus.entitystore.iterate.cached.iterator.OrderedEntityIdCollectionIterator;
import jetbrains.exodus.entitystore.iterate.cached.iterator.ReverseEntityIdArrayIteratorNullTypeId;
import jetbrains.exodus.entitystore.iterate.cached.iterator.ReverseOrderedEntityIdCollectionIterator;
import jetbrains.exodus.entitystore.util.EntityIdSetFactory;
import jetbrains.exodus.entitystore.util.ImmutableSingleTypeEntityIdCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleTypeSortedEntityIdArrayCachedInstanceIterable
extends CachedInstanceIterable {
    private final int typeId;
    private final ImmutableSingleTypeEntityIdCollection localIds;
    @Nullable
    private EntityIdSet idSet;

    public SingleTypeSortedEntityIdArrayCachedInstanceIterable(@NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase source, int typeId, long[] localIds, @Nullable EntityIdSet idSet2) {
        super(txn, source);
        this.typeId = typeId;
        this.localIds = new ImmutableSingleTypeEntityIdCollection(typeId, localIds);
        this.idSet = idSet2;
    }

    @Override
    public int getEntityTypeId() {
        return this.typeId;
    }

    @Override
    public boolean isSortedById() {
        return true;
    }

    @Override
    protected CachedInstanceIterable orderById() {
        return this;
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        return this.localIds.count();
    }

    @Override
    protected boolean containsImpl(@NotNull EntityId entityId) {
        EntityIdSet ids = this.idSet;
        if (ids != null) {
            return ids.contains(entityId);
        }
        return super.containsImpl(entityId);
    }

    @Override
    protected int indexOfImpl(@NotNull EntityId entityId) {
        int result;
        if (this.typeId == entityId.getTypeId() && (result = Arrays.binarySearch(this.localIds.getIdArray(), entityId.getLocalId())) >= 0) {
            return result;
        }
        return -1;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        if (this.typeId == Integer.MIN_VALUE) {
            return new EntityIdArrayIteratorNullTypeId(this, this.localIds.count());
        }
        return new OrderedEntityIdCollectionIterator(this, this.localIds);
    }

    @Override
    @NotNull
    public EntityIteratorBase getReverseIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        if (this.typeId == Integer.MIN_VALUE) {
            return new ReverseEntityIdArrayIteratorNullTypeId(this, this.localIds.count());
        }
        return new ReverseOrderedEntityIdCollectionIterator(this, this.localIds);
    }

    @Override
    @NotNull
    public EntityIdSet toSet(@NotNull PersistentStoreTransaction txn) {
        EntityIdSet result = this.idSet;
        if (result != null) {
            return result;
        }
        this.idSet = result = this.typeId == Integer.MIN_VALUE ? EntityIdSetFactory.newSet().add(null) : this.toSetImpl();
        return result;
    }

    @NotNull
    private EntityIdSet toSetImpl() {
        EntityIdSet result = EntityIdSetFactory.newSet();
        for (long localId : this.localIds.getIdArray()) {
            result = result.add(this.typeId, localId);
        }
        return result;
    }
}

