/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.security.auth.x500.X500Principal;
import org.apache.nifi.security.cert.builder.StandardCertificateBuilder;
import org.apache.nifi.security.configuration.KeyStoreConfiguration;
import org.apache.nifi.security.util.KeyStoreUtils;
import org.apache.nifi.security.util.KeystoreType;
import org.apache.nifi.security.util.StandardTlsConfiguration;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.security.util.TlsPlatform;

public class TemporaryKeyStoreBuilder {
    private static final String KEY_PAIR_ALGORITHM = "RSA";
    private static final int KEY_SIZE = 2048;
    private static final int RANDOM_BYTES_LENGTH = 16;
    private static final Base64.Encoder ENCODER = Base64.getEncoder().withoutPadding();
    private static final String SIGNING_ALGORITHM = "SHA256withRSA";
    private static final String DISTINGUISHED_NAME_FORMAT = "CN=%s";
    private static final int CERTIFICATE_VALID_DAYS = 1;
    private static final KeystoreType KEYSTORE_TYPE = KeystoreType.PKCS12;
    private static final String KEY_STORE_EXTENSION = ".p12";
    private static final String KEY_STORE_PREFIX = "TemporaryKeyStore-";
    private static final String DEFAULT_HOSTNAME = "localhost";
    private String hostname = "localhost";
    private String trustStorePassword = this.generateSecureRandomPassword();
    private String trustStoreType = KEYSTORE_TYPE.getType();

    public TemporaryKeyStoreBuilder hostname(String hostname) {
        this.hostname = Objects.requireNonNull(hostname, "Hostname required");
        return this;
    }

    public TemporaryKeyStoreBuilder trustStorePassword(String trustStorePassword) {
        this.trustStorePassword = Objects.requireNonNull(trustStorePassword, "TrustStore Password required");
        return this;
    }

    public TemporaryKeyStoreBuilder trustStoreType(String trustStoreType) {
        this.trustStoreType = Objects.requireNonNull(trustStoreType, "TrustStore Type required");
        return this;
    }

    public TlsConfiguration build() {
        KeyPair keyPair = this.generateKeyPair();
        X509Certificate certificate = this.generateCertificate(this.hostname, keyPair);
        KeyStoreConfiguration keyStoreConfiguration = this.setKeyStore(keyPair.getPrivate(), certificate);
        KeyStoreConfiguration trustStoreConfiguration = this.setTrustStore(certificate);
        return new StandardTlsConfiguration(keyStoreConfiguration.getLocation(), keyStoreConfiguration.getPassword(), keyStoreConfiguration.getPassword(), keyStoreConfiguration.getKeyStoreType(), trustStoreConfiguration.getLocation(), trustStoreConfiguration.getPassword(), trustStoreConfiguration.getKeyStoreType(), TlsPlatform.getLatestProtocol());
    }

    private KeyStoreConfiguration setKeyStore(PrivateKey privateKey, X509Certificate certificate) {
        KeyStore keyStore = this.getNewKeyStore(KEYSTORE_TYPE.getType());
        String password = this.generateSecureRandomPassword();
        String alias = UUID.randomUUID().toString();
        try {
            keyStore.setKeyEntry(alias, privateKey, password.toCharArray(), new Certificate[]{certificate});
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Set Key Entry Failed", e);
        }
        File keyStoreFile = this.storeKeyStore(keyStore, password.toCharArray());
        return new KeyStoreConfiguration(keyStoreFile.getAbsolutePath(), password, KEYSTORE_TYPE.getType());
    }

    private KeyStoreConfiguration setTrustStore(X509Certificate certificate) {
        KeyStore keyStore = this.getNewKeyStore(this.trustStoreType);
        String alias = UUID.randomUUID().toString();
        try {
            keyStore.setCertificateEntry(alias, certificate);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Set Certificate Entry Failed", e);
        }
        File trustStoreFile = this.storeKeyStore(keyStore, this.trustStorePassword.toCharArray());
        return new KeyStoreConfiguration(trustStoreFile.getAbsolutePath(), this.trustStorePassword, this.trustStoreType);
    }

    private File storeKeyStore(KeyStore keyStore, char[] password) {
        try {
            File keyStoreFile = File.createTempFile(KEY_STORE_PREFIX, KEY_STORE_EXTENSION);
            keyStoreFile.deleteOnExit();
            try (FileOutputStream outputStream = new FileOutputStream(keyStoreFile);){
                keyStore.store(outputStream, password);
            }
            return keyStoreFile;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException("Store KeyStore Failed", e);
        }
    }

    private KeyStore getNewKeyStore(String newKeyStoreType) {
        try {
            KeyStore keyStore = KeyStoreUtils.getKeyStore(newKeyStoreType);
            keyStore.load(null);
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(String.format("Create KeyStore [%s] Failed", KEYSTORE_TYPE), e);
        }
    }

    private X509Certificate generateCertificate(String hostname, KeyPair keyPair) {
        X500Principal distinguishedName = new X500Principal(String.format(DISTINGUISHED_NAME_FORMAT, hostname));
        List<String> dnsNames = Collections.singletonList(hostname);
        return new StandardCertificateBuilder(keyPair, distinguishedName, Duration.ofDays(1L)).setDnsSubjectAlternativeNames(dnsNames).build();
    }

    private KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_PAIR_ALGORITHM);
            keyPairGenerator.initialize(2048);
            return keyPairGenerator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(String.format("[%s] Algorithm not found", KEY_PAIR_ALGORITHM), e);
        }
    }

    private String generateSecureRandomPassword() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] randomBytes = new byte[16];
        secureRandom.nextBytes(randomBytes);
        return ENCODER.encodeToString(randomBytes);
    }
}

