/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.protocol.jaxb.message;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.nifi.cluster.protocol.ConnectionResponse;
import org.apache.nifi.cluster.protocol.jaxb.message.AdaptedConnectionResponse;

public class ConnectionResponseAdapter
extends XmlAdapter<AdaptedConnectionResponse, ConnectionResponse> {
    public AdaptedConnectionResponse marshal(ConnectionResponse cr) {
        AdaptedConnectionResponse aCr = new AdaptedConnectionResponse();
        if (cr != null) {
            aCr.setDataFlow(cr.getDataFlow());
            aCr.setNodeIdentifier(cr.getNodeIdentifier());
            aCr.setTryLaterSeconds(cr.getTryLaterSeconds());
            aCr.setRejectionReason(cr.getRejectionReason());
            aCr.setInstanceId(cr.getInstanceId());
            aCr.setNodeConnectionStatuses(cr.getNodeConnectionStatuses());
            aCr.setComponentRevisions(cr.getComponentRevisions());
        }
        return aCr;
    }

    public ConnectionResponse unmarshal(AdaptedConnectionResponse aCr) {
        if (aCr.shouldTryLater()) {
            return new ConnectionResponse(aCr.getTryLaterSeconds(), aCr.getRejectionReason());
        }
        if (aCr.getRejectionReason() != null) {
            return ConnectionResponse.createRejectionResponse(aCr.getRejectionReason());
        }
        return new ConnectionResponse(aCr.getNodeIdentifier(), aCr.getDataFlow(), aCr.getInstanceId(), aCr.getNodeConnectionStatuses(), aCr.getComponentRevisions());
    }
}

