/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.protocol;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.nifi.cluster.protocol.ComponentRevision;
import org.apache.nifi.web.revision.RevisionSnapshot;

public class ComponentRevisionSnapshot {
    private List<ComponentRevision> componentRevisions;
    private Long revisionUpdateCount;

    public List<ComponentRevision> getComponentRevisions() {
        return this.componentRevisions;
    }

    public void setComponentRevisions(List<ComponentRevision> componentRevisions) {
        this.componentRevisions = componentRevisions;
    }

    public Long getRevisionUpdateCount() {
        return this.revisionUpdateCount;
    }

    public void setRevisionUpdateCount(Long revisionUpdateCount) {
        this.revisionUpdateCount = revisionUpdateCount;
    }

    public static ComponentRevisionSnapshot fromRevisionSnapshot(RevisionSnapshot revisionSnapshot) {
        List<ComponentRevision> componentRevisions = revisionSnapshot.getRevisions().stream().map(ComponentRevision::fromRevision).collect(Collectors.toList());
        ComponentRevisionSnapshot componentRevisionSnapshot = new ComponentRevisionSnapshot();
        componentRevisionSnapshot.setComponentRevisions(componentRevisions);
        componentRevisionSnapshot.setRevisionUpdateCount(revisionSnapshot.getRevisionUpdateCount());
        return componentRevisionSnapshot;
    }

    public RevisionSnapshot toRevisionSnapshot() {
        List revisions = this.componentRevisions == null ? Collections.emptyList() : this.componentRevisions.stream().map(ComponentRevision::toRevision).collect(Collectors.toList());
        long updateCount = this.revisionUpdateCount == null ? 0L : this.revisionUpdateCount;
        return new RevisionSnapshot(revisions, updateCount);
    }
}

