/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.runtime.manifest.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.nifi.c2.protocol.component.api.BuildInfo;
import org.apache.nifi.c2.protocol.component.api.RuntimeManifest;
import org.apache.nifi.extension.manifest.Extension;
import org.apache.nifi.extension.manifest.ExtensionManifest;
import org.apache.nifi.extension.manifest.parser.ExtensionManifestParser;
import org.apache.nifi.extension.manifest.parser.jaxb.JAXBExtensionManifestParser;
import org.apache.nifi.runtime.manifest.ExtensionManifestContainer;
import org.apache.nifi.runtime.manifest.ExtensionManifestProvider;
import org.apache.nifi.runtime.manifest.RuntimeManifestSerializer;
import org.apache.nifi.runtime.manifest.impl.DirectoryExtensionManifestProvider;
import org.apache.nifi.runtime.manifest.impl.JacksonRuntimeManifestSerializer;
import org.apache.nifi.runtime.manifest.impl.SchedulingDefaultsFactory;
import org.apache.nifi.runtime.manifest.impl.StandardRuntimeManifestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeManifestGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeManifestGenerator.class);
    private static final String PROJECT_VERSION_PROPERTY = "Project-Version";
    private static final String BUILD_REVISION = "Build-Revision";
    private static final String BUILD_TIMESTAMP = "Build-Timestamp";
    private static final String BUILD_TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String BUILD_JDK = "Build-Jdk";
    private static final String BUILD_JDK_VENDOR = "Build-Jdk-Vendor";
    private final File extensionManifestBaseDir;
    private final File buildPropertiesFile;
    private final File runtimeManifestFile;
    private final String runtimeManifestId;

    public RuntimeManifestGenerator(File extensionManifestBaseDir, File buildPropertiesFile, File runtimeManifestFile, String runtimeManifestId) {
        this.extensionManifestBaseDir = extensionManifestBaseDir;
        this.buildPropertiesFile = buildPropertiesFile;
        this.runtimeManifestFile = runtimeManifestFile;
        this.runtimeManifestId = runtimeManifestId;
    }

    public void execute() throws IOException {
        long buildTimestampMillis;
        ExtensionManifestProvider extensionManifestProvider = this.createExtensionManifestProvider();
        Properties buildProperties = this.createBuildProperties();
        String runtimeVersion = buildProperties.getProperty(PROJECT_VERSION_PROPERTY);
        String buildRevision = buildProperties.getProperty(BUILD_REVISION);
        String buildTimestamp = buildProperties.getProperty(BUILD_TIMESTAMP);
        String buildJdk = buildProperties.getProperty(BUILD_JDK);
        String buildJdkVendor = buildProperties.getProperty(BUILD_JDK_VENDOR);
        try {
            SimpleDateFormat buildTimestampFormat = new SimpleDateFormat(BUILD_TIMESTAMP_FORMAT);
            Date buildTimestampDate = buildTimestampFormat.parse(buildTimestamp);
            buildTimestampMillis = buildTimestampDate.getTime();
        }
        catch (Exception e) {
            buildTimestampMillis = System.currentTimeMillis();
        }
        BuildInfo buildInfo = new BuildInfo();
        buildInfo.setVersion(runtimeVersion);
        buildInfo.setRevision(buildRevision);
        buildInfo.setTimestamp(Long.valueOf(buildTimestampMillis));
        buildInfo.setCompiler(buildJdkVendor + " " + buildJdk);
        List<ExtensionManifestContainer> extensionsManifests = extensionManifestProvider.getExtensionManifests();
        RuntimeManifest runtimeManifest = new StandardRuntimeManifestBuilder().identifier(this.runtimeManifestId).version(runtimeVersion).runtimeType("nifi").buildInfo(buildInfo).addBundles(extensionsManifests).schedulingDefaults(SchedulingDefaultsFactory.getNifiSchedulingDefaults()).build();
        RuntimeManifestSerializer runtimeManifestSerializer = this.createRuntimeManifestSerializer();
        FileOutputStream outputStream = new FileOutputStream(this.runtimeManifestFile);
        Object object = null;
        try {
            runtimeManifestSerializer.write(runtimeManifest, outputStream);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (outputStream != null) {
                if (object != null) {
                    try {
                        ((OutputStream)outputStream).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ((OutputStream)outputStream).close();
                }
            }
        }
        File docsDir = new File(this.runtimeManifestFile.getParent(), "docs");
        docsDir.mkdirs();
        for (ExtensionManifestContainer manifestContainer : extensionsManifests) {
            ExtensionManifest extensionManifest = manifestContainer.getManifest();
            Map<String, String> additionalDetailsMap = manifestContainer.getAdditionalDetails();
            File bundleDir = new File(docsDir, extensionManifest.getGroupId() + "/" + extensionManifest.getArtifactId() + "/" + extensionManifest.getVersion());
            for (Extension extension : extensionManifest.getExtensions()) {
                String extensionType = extension.getName();
                File extensionDir = new File(bundleDir, extensionType);
                String additionalDetails = additionalDetailsMap.get(extensionType);
                if (additionalDetails == null) continue;
                extensionDir.mkdirs();
                File additionalDetailsFile = new File(extensionDir, "additionalDetails.html");
                Files.write(additionalDetailsFile.toPath(), additionalDetails.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
        }
    }

    private ExtensionManifestProvider createExtensionManifestProvider() {
        JAXBExtensionManifestParser extensionManifestParser = new JAXBExtensionManifestParser();
        return new DirectoryExtensionManifestProvider(this.extensionManifestBaseDir, (ExtensionManifestParser)extensionManifestParser);
    }

    private Properties createBuildProperties() throws IOException {
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(this.buildPropertiesFile);){
            properties.load(inputStream);
        }
        return properties;
    }

    private RuntimeManifestSerializer createRuntimeManifestSerializer() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        ObjectWriter objectWriter = objectMapper.writerWithDefaultPrettyPrinter();
        return new JacksonRuntimeManifestSerializer(objectWriter);
    }

    public static void main(String[] args) throws IOException {
        if (args == null || args.length != 4) {
            System.out.println("USAGE: <extension-manifest-base-dir> <build-props-file> <output-file> <manifest-id>");
            return;
        }
        File extensionManifestBaseDir = new File(args[0]);
        File buildPropertiesFile = new File(args[1]);
        File runtimeManifestFile = new File(args[2]);
        String runtimeManifestId = args[3];
        File runtimeManifestDir = runtimeManifestFile.getParentFile();
        if (runtimeManifestDir != null) {
            runtimeManifestDir.mkdirs();
        }
        LOGGER.info("Writing runtime manifest to: {}", (Object)runtimeManifestFile.getAbsolutePath());
        RuntimeManifestGenerator runner = new RuntimeManifestGenerator(extensionManifestBaseDir, buildPropertiesFile, runtimeManifestFile, runtimeManifestId);
        runner.execute();
    }
}

