/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.client.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.ws.rs.client.WebTarget;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.extension.ExtensionFilterParams;
import org.apache.nifi.extension.ExtensionMetadataContainer;
import org.apache.nifi.extension.TagCount;
import org.apache.nifi.extension.manifest.ExtensionType;
import org.apache.nifi.extension.manifest.ProvidedServiceAPI;
import org.apache.nifi.registry.client.ExtensionClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.client.RequestConfig;
import org.apache.nifi.registry.client.impl.AbstractJerseyClient;
import org.apache.nifi.registry.extension.bundle.BundleType;

public class JerseyExtensionClient
extends AbstractJerseyClient
implements ExtensionClient {
    private final WebTarget extensionsTarget;

    public JerseyExtensionClient(WebTarget baseTarget) {
        this(baseTarget, null);
    }

    public JerseyExtensionClient(WebTarget baseTarget, RequestConfig requestConfig) {
        super(requestConfig);
        this.extensionsTarget = baseTarget.path("extensions");
    }

    @Override
    public ExtensionMetadataContainer findExtensions(ExtensionFilterParams filterParams) throws IOException, NiFiRegistryException {
        return this.executeAction("Error retrieving extensions", () -> {
            WebTarget target = this.extensionsTarget;
            if (filterParams != null) {
                Set tags;
                ExtensionType extensionType;
                BundleType bundleType = filterParams.getBundleType();
                if (bundleType != null) {
                    target = target.queryParam("bundleType", new Object[]{bundleType.toString()});
                }
                if ((extensionType = filterParams.getExtensionType()) != null) {
                    target = target.queryParam("extensionType", new Object[]{extensionType.toString()});
                }
                if ((tags = filterParams.getTags()) != null) {
                    for (String tag : tags) {
                        target = target.queryParam("tag", new Object[]{tag});
                    }
                }
            }
            return (ExtensionMetadataContainer)this.getRequestBuilder(target).get(ExtensionMetadataContainer.class);
        });
    }

    @Override
    public ExtensionMetadataContainer findExtensions(ProvidedServiceAPI serviceAPI) throws IOException, NiFiRegistryException {
        if (serviceAPI == null || StringUtils.isBlank((CharSequence)serviceAPI.getClassName()) || StringUtils.isBlank((CharSequence)serviceAPI.getGroupId()) || StringUtils.isBlank((CharSequence)serviceAPI.getArtifactId()) || StringUtils.isBlank((CharSequence)serviceAPI.getVersion())) {
            throw new IllegalArgumentException("Provided service API must be specified with a class, group, artifact, and version");
        }
        return this.executeAction("Error retrieving extensions", () -> {
            WebTarget target = this.extensionsTarget.path("provided-service-api");
            target = target.queryParam("className", new Object[]{serviceAPI.getClassName()});
            target = target.queryParam("groupId", new Object[]{serviceAPI.getGroupId()});
            target = target.queryParam("artifactId", new Object[]{serviceAPI.getArtifactId()});
            target = target.queryParam("version", new Object[]{serviceAPI.getVersion()});
            return (ExtensionMetadataContainer)this.getRequestBuilder(target).get(ExtensionMetadataContainer.class);
        });
    }

    @Override
    public List<TagCount> getTagCounts() throws IOException, NiFiRegistryException {
        return this.executeAction("Error retrieving tag counts", () -> {
            WebTarget target = this.extensionsTarget.path("tags");
            TagCount[] tagCounts = (TagCount[])this.getRequestBuilder(target).get(TagCount[].class);
            return tagCounts == null ? Collections.emptyList() : Arrays.asList(tagCounts);
        });
    }
}

